/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.camel.CamelContext;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader FALLBACK_CLASS_LOADER = ClassLoadingAwareObjectInputStream.class.getClassLoader();
    private static final HashMap<String, Class> PRIM_CLASSES = new HashMap(8, 1.0f);
    private CamelContext camelContext;
    private final ClassLoader inLoader;

    public ClassLoadingAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.inLoader = in.getClass().getClassLoader();
    }

    public ClassLoadingAwareObjectInputStream(CamelContext camelContext, InputStream in) throws IOException {
        super(in);
        this.inLoader = camelContext.getApplicationContextClassLoader();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.load(classDesc.getName(), cl, this.inLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i], cl);
        }
        try {
            return Proxy.getProxyClass(cl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            try {
                return Proxy.getProxyClass(this.inLoader, cinterfaces);
            }
            catch (IllegalArgumentException e1) {
                try {
                    return Proxy.getProxyClass(FALLBACK_CLASS_LOADER, cinterfaces);
                }
                catch (IllegalArgumentException e2) {
                    throw new ClassNotFoundException(null, e);
                }
            }
        }
    }

    private Class<?> load(String className, ClassLoader ... cl) throws ClassNotFoundException {
        for (ClassLoader loader : cl) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (ClassNotFoundException e) {
            }
        }
        Class clazz = PRIM_CLASSES.get(className);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(className, false, FALLBACK_CLASS_LOADER);
    }

    static {
        PRIM_CLASSES.put("boolean", Boolean.TYPE);
        PRIM_CLASSES.put("byte", Byte.TYPE);
        PRIM_CLASSES.put("char", Character.TYPE);
        PRIM_CLASSES.put("short", Short.TYPE);
        PRIM_CLASSES.put("int", Integer.TYPE);
        PRIM_CLASSES.put("long", Long.TYPE);
        PRIM_CLASSES.put("float", Float.TYPE);
        PRIM_CLASSES.put("double", Double.TYPE);
        PRIM_CLASSES.put("void", Void.TYPE);
    }
}

