/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SqlEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":query";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "sql".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "query", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(49);
        props.add("synchronous");
        props.add("initialDelay");
        props.add("allowNamedParameters");
        props.add("usePlaceholder");
        props.add("templateOptions");
        props.add("bridgeErrorHandler");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("query");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("batch");
        props.add("separator");
        props.add("backoffIdleThreshold");
        props.add("processingStrategy");
        props.add("prepareStatementStrategy");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("startScheduler");
        props.add("outputClass");
        props.add("dataSource");
        props.add("exceptionHandler");
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("breakBatchOnConsumeFail");
        props.add("onConsume");
        props.add("onConsumeFailed");
        props.add("useMessageBodyForSql");
        props.add("dataSourceRef");
        props.add("outputType");
        props.add("transacted");
        props.add("useIterator");
        props.add("parametersCount");
        props.add("scheduler");
        props.add("noop");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("placeholder");
        props.add("timeUnit");
        props.add("onConsumeBatchComplete");
        props.add("exchangePattern");
        props.add("routeEmptyResultSet");
        props.add("alwaysPopulateStatement");
        props.add("outputHeader");
        props.add("pollStrategy");
        props.add("expectedUpdateCount");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

