/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public abstract class EndpointUriFactorySupport
implements EndpointUriFactory {
    protected CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected String buildPathParameter(String syntax, String uri, String name, Object defaultValue, boolean required, Map<String, Object> parameters) {
        Object obj = parameters.remove(name);
        if (ObjectHelper.isEmpty((Object)obj) && defaultValue != null && required) {
            obj = this.camelContext.getTypeConverter().convertTo(String.class, defaultValue);
        }
        if (ObjectHelper.isEmpty((Object)obj) && required) {
            throw new IllegalArgumentException("Option " + name + " is required when creating endpoint uri with syntax " + syntax);
        }
        if (ObjectHelper.isNotEmpty((Object)obj)) {
            String str = (String)this.camelContext.getTypeConverter().convertTo(String.class, obj);
            int occurrence = StringHelper.countOccurrence((String)uri, (String)name);
            uri = occurrence > 1 ? StringHelper.replaceFromSecondOccurrence((String)uri, (String)name, (String)str) : ((String)uri).replace(name, str);
        } else {
            char ch;
            int pos = ((String)uri).indexOf(name);
            if (pos != -1 && !Character.isLetterOrDigit(ch = ((String)(uri = ((String)uri).replaceFirst(name, ""))).charAt(--pos))) {
                uri = ((String)uri).substring(0, pos) + ((String)uri).substring(pos + 1);
            }
        }
        return uri;
    }

    protected String buildQueryParameters(String uri, Map<String, Object> parameters, boolean encode) {
        Object val;
        TreeMap<String, Object> map = new TreeMap<String, Object>(parameters);
        for (String string : this.secretPropertyNames()) {
            String answer;
            val = map.get(string);
            if (!(val instanceof String) || (answer = (String)val).startsWith("#") || answer.startsWith("RAW(")) continue;
            map.put(string, "RAW(" + String.valueOf(val) + ")");
        }
        for (Map.Entry entry : this.multiValuePrefixes().entrySet()) {
            val = map.get(entry.getKey());
            String prefix = (String)entry.getValue();
            if (!(val instanceof Map)) continue;
            Map m = (Map)val;
            for (Object k : m.keySet()) {
                String key = prefix + String.valueOf(k);
                val = m.get(k);
                if (val == null) continue;
                map.put(key, val);
            }
            map.remove(entry.getKey());
        }
        String query = URISupport.createQueryString(map, (boolean)encode);
        if (ObjectHelper.isNotEmpty((String)query)) {
            boolean bl = ((String)uri).indexOf(63) != -1;
            uri = bl ? (String)uri + "&" + query : (String)uri + "?" + query;
        }
        return uri;
    }
}

