/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import java.util.List;
import org.apache.camel.quarkus.core.deployment.CamelRuntimeBeanBuildItem;

class MongoDbProcessor {
    private static final String FEATURE = "camel-mongodb";

    MongoDbProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerCamelMongoClientProducer(List<MongoClientBuildItem> mongoClients, BuildProducer<CamelRuntimeBeanBuildItem> runtimeBeans) {
        for (MongoClientBuildItem mongoClient : mongoClients) {
            if (!"<default>".equals(mongoClient.getName())) continue;
            runtimeBeans.produce((BuildItem)new CamelRuntimeBeanBuildItem("camelMongoClient", "com.mongodb.client.MongoClient", mongoClients.get(0).getClient()));
        }
    }
}

