/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel413;

import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelYamlVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class YamlDsl413Recipe
extends Recipe {
    public String getDisplayName() {
        return "Camel YML DSL changes";
    }

    public String getDescription() {
        return "Apache Camel YML DSL migration from version 4.12 o 4.13.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelYamlVisitor(){

            @Override
            protected void clearLocalCache() {
            }

            @Override
            public Yaml.Mapping.Entry doVisitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                String origValue;
                String camelCase;
                Yaml.Mapping.Entry e = super.doVisitMappingEntry(entry, ctx);
                if (e.getKey() instanceof Yaml.Scalar && (camelCase = RecipesUtil.kebabCaseToCamelCase(origValue = e.getKey().getValue())) != null && !camelCase.equals(origValue)) {
                    return e.withKey((YamlKey)((Yaml.Scalar)e.getKey().copyPaste()).withValue(camelCase));
                }
                String path = RecipesUtil.getProperty(this.getCursor());
                if (path.endsWith("unmarshal.fury") || path.endsWith("marshal.fury")) {
                    return e.withKey((YamlKey)((Yaml.Scalar)e.getKey().copyPaste()).withValue("fory"));
                }
                return e;
            }
        };
    }

    @Generated
    public YamlDsl413Recipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "YamlDsl413Recipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlDsl413Recipe)) {
            return false;
        }
        YamlDsl413Recipe other = (YamlDsl413Recipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof YamlDsl413Recipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

