/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingFunction;

public interface Railway<F, S> {
    public static <F, S> Success<F, S> success(@Nullable S success) {
        return new Success(success);
    }

    public static <F, S> Failure<F, S> failure(@NonNull F failure) {
        if (failure == null) {
            throw new NullPointerException("failure is marked non-null but is null");
        }
        return new Failure(failure);
    }

    public boolean isSuccess();

    public boolean isFailure();

    public Optional<S> getSuccess();

    default public S getSuccessElseFail() {
        return this.getSuccess().orElseThrow();
    }

    default public S getSuccessElseFail(Function<F, ? extends Throwable> toThrowable) {
        Optional<S> successIfAny = this.getSuccess();
        if (successIfAny.isPresent()) {
            return successIfAny.get();
        }
        throw toThrowable.apply(this.getFailureElseFail());
    }

    public Optional<F> getFailure();

    default public F getFailureElseFail() {
        return this.getFailure().orElseThrow();
    }

    public Railway<F, S> ifSuccess(@NonNull ThrowingConsumer<S> var1);

    public Railway<F, S> ifFailure(@NonNull ThrowingConsumer<F> var1);

    public <R> Railway<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> var1);

    public <R> Railway<R, S> mapFailure(@NonNull ThrowingFunction<F, R> var1);

    public <R> R fold(@NonNull ThrowingFunction<F, R> var1, @NonNull ThrowingFunction<S, R> var2);

    public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> var1);

    public static final class Success<F, S>
    implements Railway<F, S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final S success;

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public Optional<S> getSuccess() {
            return Optional.of(this.success);
        }

        @Override
        public Optional<F> getFailure() {
            return Optional.empty();
        }

        @Override
        public Success<F, S> ifSuccess(@NonNull ThrowingConsumer<S> successConsumer) {
            if (successConsumer == null) {
                throw new NullPointerException("successConsumer is marked non-null but is null");
            }
            successConsumer.accept(this.success);
            return this;
        }

        @Override
        public Success<F, S> ifFailure(@NonNull ThrowingConsumer<F> failureConsumer) {
            if (failureConsumer == null) {
                throw new NullPointerException("failureConsumer is marked non-null but is null");
            }
            return this;
        }

        @Override
        public <R> Success<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return Railway.success(successMapper.apply(this.success));
        }

        @Override
        public <R> Success<R, S> mapFailure(@NonNull ThrowingFunction<F, R> failureMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            return Railway.success(this.success);
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<F, R> failureMapper, @NonNull ThrowingFunction<S, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return (R)successMapper.apply(this.success);
        }

        @Override
        public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> chainingFunction) {
            if (chainingFunction == null) {
                throw new NullPointerException("chainingFunction is marked non-null but is null");
            }
            return (Railway)chainingFunction.apply(this.success);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Success)) {
                return false;
            }
            Success other = (Success)o;
            Optional<S> this$success = this.getSuccess();
            Optional<S> other$success = other.getSuccess();
            return !(this$success == null ? other$success != null : !((Object)this$success).equals(other$success));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<S> $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            return result;
        }

        public String toString() {
            return "Railway.Success(success=" + this.getSuccess() + ")";
        }

        public Success(@NonNull S success) {
            if (success == null) {
                throw new NullPointerException("success is marked non-null but is null");
            }
            this.success = success;
        }
    }

    public static final class Failure<F, S>
    implements Railway<F, S>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final F failure;

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public Optional<S> getSuccess() {
            return Optional.empty();
        }

        @Override
        public Optional<F> getFailure() {
            return Optional.of(this.failure);
        }

        @Override
        public Failure<F, S> ifSuccess(@NonNull ThrowingConsumer<S> successConsumer) {
            if (successConsumer == null) {
                throw new NullPointerException("successConsumer is marked non-null but is null");
            }
            return this;
        }

        @Override
        public Failure<F, S> ifFailure(@NonNull ThrowingConsumer<F> failureConsumer) {
            if (failureConsumer == null) {
                throw new NullPointerException("failureConsumer is marked non-null but is null");
            }
            failureConsumer.accept(this.failure);
            return this;
        }

        @Override
        public <R> Failure<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return Railway.failure(this.failure);
        }

        @Override
        public <R> Failure<R, S> mapFailure(@NonNull ThrowingFunction<F, R> failureMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            return Railway.failure(failureMapper.apply(this.failure));
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<F, R> failureMapper, @NonNull ThrowingFunction<S, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return (R)failureMapper.apply(this.failure);
        }

        @Override
        public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> chainingFunction) {
            if (chainingFunction == null) {
                throw new NullPointerException("chainingFunction is marked non-null but is null");
            }
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Failure)) {
                return false;
            }
            Failure other = (Failure)o;
            Optional<F> this$failure = this.getFailure();
            Optional<F> other$failure = other.getFailure();
            return !(this$failure == null ? other$failure != null : !((Object)this$failure).equals(other$failure));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<F> $failure = this.getFailure();
            result = result * 59 + ($failure == null ? 43 : ((Object)$failure).hashCode());
            return result;
        }

        public String toString() {
            return "Railway.Failure(failure=" + this.getFailure() + ")";
        }

        public Failure(@NonNull F failure) {
            if (failure == null) {
                throw new NullPointerException("failure is marked non-null but is null");
            }
            this.failure = failure;
        }
    }

    @FunctionalInterface
    public static interface HasRailway<F, S>
    extends Railway<F, S> {
        public Railway<F, S> getRailway();

        @Override
        default public boolean isSuccess() {
            return this.getRailway().isSuccess();
        }

        @Override
        default public boolean isFailure() {
            return this.getRailway().isFailure();
        }

        @Override
        default public Optional<S> getSuccess() {
            return this.getRailway().getSuccess();
        }

        @Override
        default public Optional<F> getFailure() {
            return this.getRailway().getFailure();
        }

        @Override
        default public Railway<F, S> ifSuccess(@NonNull ThrowingConsumer<S> successConsumer) {
            if (successConsumer == null) {
                throw new NullPointerException("successConsumer is marked non-null but is null");
            }
            return this.getRailway().ifSuccess(successConsumer);
        }

        @Override
        default public Railway<F, S> ifFailure(@NonNull ThrowingConsumer<F> failureConsumer) {
            if (failureConsumer == null) {
                throw new NullPointerException("failureConsumer is marked non-null but is null");
            }
            return this.getRailway().ifFailure(failureConsumer);
        }

        @Override
        default public <R> Railway<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> successMapper) {
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return this.getRailway().mapSuccess(successMapper);
        }

        @Override
        default public <R> Railway<R, S> mapFailure(@NonNull ThrowingFunction<F, R> failureMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            return this.getRailway().mapFailure(failureMapper);
        }

        @Override
        default public <R> R fold(@NonNull ThrowingFunction<F, R> failureMapper, @NonNull ThrowingFunction<S, R> successMapper) {
            if (failureMapper == null) {
                throw new NullPointerException("failureMapper is marked non-null but is null");
            }
            if (successMapper == null) {
                throw new NullPointerException("successMapper is marked non-null but is null");
            }
            return this.getRailway().fold(failureMapper, successMapper);
        }

        @Override
        default public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> chainingFunction) {
            if (chainingFunction == null) {
                throw new NullPointerException("chainingFunction is marked non-null but is null");
            }
            return this.getRailway().chain(chainingFunction);
        }
    }
}

