/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.util.Objects;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public final class _Objects {
    public static <T> int compareNullsFirst(@Nullable T a, @Nullable T b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)_Casts.uncheckedCast(a)).compareTo(b);
        }
        if (b instanceof Comparable) {
            return _Objects.negate(((Comparable)_Casts.uncheckedCast(b)).compareTo(a));
        }
        throw _Exceptions.unsupportedOperation("cannot compare objects if non of them is 'comparable'");
    }

    public static <T> int compareNullsLast(@Nullable T a, @Nullable T b) {
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)_Casts.uncheckedCast(a)).compareTo(b);
        }
        if (b instanceof Comparable) {
            return _Objects.negate(((Comparable)_Casts.uncheckedCast(b)).compareTo(a));
        }
        throw _Exceptions.unsupportedOperation("cannot compare objects if non of them is 'comparable'");
    }

    public static <T> int compareNonNull(T a, T b) {
        if (a instanceof Comparable) {
            return ((Comparable)_Casts.uncheckedCast(a)).compareTo(b);
        }
        if (b instanceof Comparable) {
            return _Objects.negate(((Comparable)_Casts.uncheckedCast(b)).compareTo(a));
        }
        throw _Exceptions.unsupportedOperation("cannot compare objects if non of them is 'comparable'");
    }

    private static final int negate(int x) {
        if (x == Integer.MIN_VALUE) {
            return 1;
        }
        return -x;
    }
}

