/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Collections;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.springframework.lang.Nullable;

public final class _Sets {
    public static <T> Set<T> singleton(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return Collections.singleton(element);
    }

    public static <T> Set<T> singletonOrElseEmpty(@Nullable T element) {
        return element != null ? Collections.singleton(element) : Collections.emptySet();
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (elements.length == 0) {
            return Collections.emptySet();
        }
        return Stream.of(elements).collect(_Sets.toUnmodifiable(LinkedHashSet::new));
    }

    @SafeVarargs
    public static <T> SortedSet<T> ofSorted(T ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        if (elements.length == 0) {
            return Collections.emptySortedSet();
        }
        return Collections.unmodifiableSortedSet(Stream.of(elements).collect(Collectors.toCollection(TreeSet::new)));
    }

    public static <T> Set<T> unmodifiable(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        return _NullSafe.stream(iterable).collect(_Sets.toUnmodifiable(LinkedHashSet::new));
    }

    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<T> comparator) {
        return comparator != null ? new TreeSet<T>(comparator) : new TreeSet();
    }

    public static <T> TreeSet<T> newTreeSet(@Nullable Iterable<T> iterable) {
        return _NullSafe.stream(iterable).collect(Collectors.toCollection(TreeSet::new));
    }

    public static <T> TreeSet<T> newTreeSet(@Nullable Iterable<T> iterable, @Nullable Comparator<T> comparator) {
        return _NullSafe.stream(iterable).collect(Collectors.toCollection(() -> new TreeSet(comparator)));
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Sets.newHashSet();
        }
        return new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newHashSet, () -> Collectors.toCollection(HashSet::new));
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Sets.newLinkedHashSet();
        }
        return new LinkedHashSet<T>(collection);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newLinkedHashSet, () -> Collectors.toCollection(LinkedHashSet::new));
    }

    public static <T> ConcurrentHashMap.KeySetView<T, Boolean> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    public static <T> ConcurrentHashMap.KeySetView<T, Boolean> newConcurrentHashSet(@Nullable Collection<T> collection) {
        ConcurrentHashMap.KeySetView<T, Boolean> keySetView = _Sets.newConcurrentHashSet();
        if (collection != null) {
            keySetView.addAll(collection);
        }
        return keySetView;
    }

    public static <T> ConcurrentHashMap.KeySetView<T, Boolean> newConcurrentHashSet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newConcurrentHashSet, () -> Collectors.toCollection(ConcurrentHashMap::newKeySet));
    }

    public static <T> CopyOnWriteArraySet<T> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    public static <T> CopyOnWriteArraySet<T> newCopyOnWriteArraySet(@Nullable Collection<T> collection) {
        if (collection == null) {
            return _Sets.newCopyOnWriteArraySet();
        }
        return new CopyOnWriteArraySet<T>(collection);
    }

    public static <T> CopyOnWriteArraySet<T> newCopyOnWriteArraySet(@Nullable Iterable<T> iterable) {
        return _Collections.collectFromIterable(iterable, _Sets::newCopyOnWriteArraySet, () -> Collectors.toCollection(CopyOnWriteArraySet::new));
    }

    public static <T> Set<T> intersect(@Nullable Set<T> a, @Nullable Set<T> b) {
        if (a == null && b == null) {
            return Collections.emptySet();
        }
        if (a == null || b == null) {
            return Collections.emptySet();
        }
        return a.stream().filter(Objects::nonNull).filter(b::contains).collect(_Sets.toUnmodifiable());
    }

    public static <T> SortedSet<T> intersectSorted(@Nullable SortedSet<T> a, @Nullable SortedSet<T> b) {
        if (a == null && b == null) {
            return Collections.emptySortedSet();
        }
        if (a == null || b == null) {
            return Collections.emptySortedSet();
        }
        return a.stream().filter(Objects::nonNull).filter(b::contains).collect(_Sets.toUnmodifiableSorted());
    }

    public static <T> Set<T> minus(@Nullable Set<T> a, @Nullable Set<T> b) {
        return _Sets.minus(a, b, HashSet::new);
    }

    public static <T> SortedSet<T> minusSorted(@Nullable SortedSet<T> a, @Nullable SortedSet<T> b) {
        return _Sets.minusSorted(a, b, TreeSet::new);
    }

    public static <T> Set<T> minus(@Nullable Set<T> a, @Nullable Set<T> b, @NonNull Supplier<Set<T>> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        if (a == null || a.isEmpty()) {
            return Collections.emptySet();
        }
        if (b == null || b.isEmpty()) {
            Set<T> copy = collectionFactory.get();
            copy.addAll(a);
            return Collections.unmodifiableSet(copy);
        }
        return a.stream().filter(Objects::nonNull).filter(_Predicates.not(b::contains)).collect(_Sets.toUnmodifiable(collectionFactory));
    }

    public static <T> SortedSet<T> minusSorted(@Nullable SortedSet<T> a, @Nullable SortedSet<T> b, @NonNull Supplier<SortedSet<T>> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        if (a == null || a.isEmpty()) {
            return Collections.emptySortedSet();
        }
        if (b == null || b.isEmpty()) {
            SortedSet<T> copy = collectionFactory.get();
            copy.addAll(a);
            return Collections.unmodifiableSortedSet(copy);
        }
        return a.stream().filter(Objects::nonNull).filter(_Predicates.not(b::contains)).collect(_Sets.toUnmodifiableSorted());
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiable(Supplier<Set<T>> collectionFactory) {
        return Collectors.collectingAndThen(Collectors.toCollection(collectionFactory), Collections::unmodifiableSet);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiable() {
        return _Sets.toUnmodifiable(HashSet::new);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiablePreservingOrder() {
        return _Sets.toUnmodifiable(LinkedHashSet::new);
    }

    public static <T> Collector<T, ?, SortedSet<T>> toUnmodifiableSorted(Supplier<SortedSet<T>> collectionFactory) {
        return Collectors.collectingAndThen(Collectors.toCollection(collectionFactory), Collections::unmodifiableSortedSet);
    }

    public static <T> Collector<T, ?, SortedSet<T>> toUnmodifiableSorted() {
        return _Sets.toUnmodifiableSorted(TreeSet::new);
    }

    private _Sets() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

