/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.commons.internal.factory._InstanceCreationClassException;
import org.apache.causeway.commons.internal.factory._InstanceCreationException;
import org.apache.causeway.commons.internal.factory._UnavailableClassException;

public final class _InstanceUtil {
    private _InstanceUtil() {
    }

    public static Object createInstance(String className, Object ... args) {
        return _InstanceUtil.createInstance(className, (Class)null, null, args);
    }

    public static Object createInstance(Class<?> cls, Object ... args) {
        return _InstanceUtil.createInstance(cls, (Class)null, null, args);
    }

    public static <T> T createInstance(String className, Class<T> requiredClass, Object ... args) {
        return _InstanceUtil.createInstance(className, (Class)null, requiredClass, args);
    }

    public static <T> T createInstance(Class<?> cls, Class<T> requiredClass, Object ... args) {
        return _InstanceUtil.createInstance(cls, (Class)null, requiredClass, args);
    }

    public static <T> T createInstance(String className, String defaultTypeName, Class<T> requiredType, Object ... args) {
        Class defaultType = null;
        if (defaultTypeName != null) {
            try {
                defaultType = (Class)_Casts.uncheckedCast(_Context.loadClass(defaultTypeName));
                if (defaultType == null) {
                    throw new _InstanceCreationClassException(String.format("Failed to load default type '%s'", defaultTypeName));
                }
            }
            catch (ClassNotFoundException e) {
                throw new _UnavailableClassException(String.format("The default type '%s' cannot be found", defaultTypeName));
            }
            catch (NoClassDefFoundError e) {
                throw new _InstanceCreationClassException(String.format("Default type '%s' found, but is missing a dependent class: %s", defaultTypeName, e.getMessage()), e);
            }
        }
        return _InstanceUtil.createInstance(className, defaultType, requiredType, args);
    }

    public static <T> T createInstance(Class<?> cls, String defaultTypeName, Class<T> requiredType, Object ... args) {
        Class defaultType = null;
        if (defaultTypeName != null) {
            defaultType = _InstanceUtil.loadClass(defaultTypeName, requiredType);
            try {
                defaultType = (Class)_Casts.uncheckedCast(_Context.loadClass(defaultTypeName));
                if (defaultType == null) {
                    throw new _InstanceCreationClassException(String.format("Failed to load default type '%s'", defaultTypeName));
                }
            }
            catch (ClassNotFoundException e) {
                throw new _UnavailableClassException(String.format("The default type '%s' cannot be found", defaultTypeName));
            }
            catch (NoClassDefFoundError e) {
                throw new _InstanceCreationClassException(String.format("Default type '%s' found, but is missing a dependent class: %s", defaultTypeName, e.getMessage()), e);
            }
        }
        return _InstanceUtil.createInstance(cls, defaultType, requiredType, args);
    }

    public static <T> T createInstance(String className, Class<? extends T> defaultType, Class<T> requiredType, Object ... args) {
        _Assert.assertNotNull((Object)"Class to instantiate must be specified", className);
        try {
            Class<?> cls = _Context.loadClass(className);
            if (cls == null) {
                throw new _InstanceCreationClassException(String.format("Failed to load class '%s'", className));
            }
            return _InstanceUtil.createInstance(cls, defaultType, requiredType, args);
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(46) == -1) {
                throw new _UnavailableClassException(String.format("The component '%s' cannot be found", className));
            }
            throw new _UnavailableClassException(String.format("The class '%s' cannot be found", className));
        }
        catch (NoClassDefFoundError e) {
            throw new _InstanceCreationClassException(String.format("Class '%s' found , but is missing a dependent class: %s", className, e.getMessage()), e);
        }
    }

    public static <T> T createInstance(Class<?> cls, Class<? extends T> defaultType, Class<T> requiredType, Object ... args) {
        _Assert.assertNotNull(cls, "Class to instantiate must be specified");
        try {
            if (requiredType == null || requiredType.isAssignableFrom(cls)) {
                Class tClass = (Class)_Casts.uncheckedCast(cls);
                if (args == null || args.length == 0) {
                    return tClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                Class[] paramTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    paramTypes[i] = arg.getClass();
                }
                Constructor constructor = tClass.getConstructor(paramTypes);
                return constructor.newInstance(args);
            }
            throw new _InstanceCreationClassException(String.format("Class '%s' is not of type '%s'", cls.getName(), requiredType));
        }
        catch (NoClassDefFoundError e) {
            throw new _InstanceCreationClassException(String.format("Class '%s'found , but is missing a dependent class: %s", cls, e.getMessage()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new _InstanceCreationException(String.format("Could not instantiate an object of class '%s'; %s", cls.getName(), e.getMessage()), e);
        }
        catch (IllegalAccessException e) {
            throw new _InstanceCreationException(String.format("Could not access the class '%s'; %s", cls.getName(), e.getMessage()), e);
        }
        catch (NoSuchMethodException e) {
            throw new _InstanceCreationException(String.format("Could not find constructor in the class '%s'; %s", cls.getName(), e.getMessage()), e);
        }
    }

    public static Class<?> loadClass(String className) {
        _Assert.assertNotNull((Object)"Class to instantiate must be specified", className);
        try {
            return _Context.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new _UnavailableClassException(String.format("The type '%s' cannot be found", className));
        }
        catch (NoClassDefFoundError e) {
            throw new _InstanceCreationClassException(String.format("Type '%s' found, but is missing a dependent class: %s", className, e.getMessage()), e);
        }
    }

    public static <R, T extends R> Class<T> loadClass(String className, Class<R> requiredType) {
        _Assert.assertNotNull((Object)"Class to instantiate must be specified", className);
        try {
            Class<?> loadedClass = _InstanceUtil.loadClass(className);
            if (requiredType != null && !requiredType.isAssignableFrom(loadedClass)) {
                throw new _InstanceCreationClassException("Class '" + className + "' is not of type '" + requiredType + "'");
            }
            return (Class)_Casts.uncheckedCast(loadedClass);
        }
        catch (NoClassDefFoundError e) {
            throw new _InstanceCreationClassException(String.format("Default type '%s' found, but is missing a dependent class: %s", className, e.getMessage()), e);
        }
    }
}

