/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public final class _VersionedList<T> {
    private UUID uuid = UUID.randomUUID();
    private final List<List<T>> versions = new ArrayList<List<T>>();
    private List<T> currentVersion = new ArrayList<T>();
    private int size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot<T> snapshot() {
        List<List<T>> list = this.versions;
        synchronized (list) {
            this.commit();
            return new Snapshot<T>(this.uuid, 0, this.versions.size(), this.defensiveCopy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot<T> deltaSince(@NonNull Snapshot<T> snapshot) {
        if (snapshot == null) {
            throw new NullPointerException("snapshot is marked non-null but is null");
        }
        if (snapshot.ownerUuid != this.uuid) {
            throw new IllegalArgumentException("Snapshot's UUID is different from the VersionedList's.");
        }
        List<List<T>> list = this.versions;
        synchronized (list) {
            this.commit();
            int from = snapshot.toIndex;
            int to = this.versions.size();
            return new Snapshot<T>(this.uuid, from, to, this.defensiveCopy(from, to));
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> stream() {
        List<List<T>> defensiveCopy;
        List<List<T>> list = this.versions;
        synchronized (list) {
            this.commit();
            defensiveCopy = this.defensiveCopy();
        }
        return defensiveCopy.stream().flatMap(Collection::stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T e) {
        List<List<T>> list = this.versions;
        synchronized (list) {
            ++this.size;
            return this.currentVersion.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends T> c) {
        List<List<T>> list = this.versions;
        synchronized (list) {
            this.size += c.size();
            return this.currentVersion.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<List<T>> list = this.versions;
        synchronized (list) {
            this.uuid = UUID.randomUUID();
            this.size = 0;
            this.versions.clear();
            this.currentVersion.clear();
        }
    }

    public void forEach(Consumer<T> action) {
        Snapshot<T> snapshot = this.snapshot();
        snapshot.forEach(action);
        Snapshot<T> delta = this.deltaSince(snapshot);
        while (!delta.isEmpty()) {
            delta.forEach(action);
            delta = this.deltaSince(delta);
        }
    }

    public void forEachConcurrent(Consumer<T> action) {
        Snapshot<T> snapshot = this.snapshot();
        snapshot.forEachParallel(action);
        Snapshot<T> delta = this.deltaSince(snapshot);
        while (!delta.isEmpty()) {
            delta.forEachParallel(action);
            delta = this.deltaSince(delta);
        }
    }

    private List<List<T>> defensiveCopy(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return Collections.emptyList();
        }
        return new ArrayList<List<T>>(this.versions.subList(fromIndex, toIndex));
    }

    private List<List<T>> defensiveCopy() {
        if (this.versions.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<List<T>>(this.versions);
    }

    private void commit() {
        if (!this.currentVersion.isEmpty()) {
            this.versions.add(this.currentVersion);
            this.currentVersion = new ArrayList<T>();
        }
    }

    public static final class Snapshot<T> {
        private UUID ownerUuid;
        private final int fromIndex;
        private final int toIndex;
        private final List<List<T>> versions;

        public boolean isEmpty() {
            return this.versions.isEmpty();
        }

        public Stream<T> stream() {
            return this.versions.stream().flatMap(Collection::stream);
        }

        public void forEach(Consumer<T> action) {
            for (List<T> ver : this.versions) {
                for (T element : ver) {
                    action.accept(element);
                }
            }
        }

        public void forEachParallel(Consumer<T> action) {
            for (List<T> ver : this.versions) {
                if (ver.size() > 8) {
                    ver.parallelStream().forEach(action);
                    continue;
                }
                for (T element : ver) {
                    action.accept(element);
                }
            }
        }

        @Generated
        private Snapshot(UUID ownerUuid, int fromIndex, int toIndex, List<List<T>> versions) {
            this.ownerUuid = ownerUuid;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.versions = versions;
        }
    }
}

