/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.debug.xray.graphics._Graphics;
import org.apache.causeway.commons.internal.primitives._Ints;

public class SequenceDiagram {
    private final Map<String, String> aliases = new TreeMap<String, String>();
    private final Map<String, Participant> participantsById = new LinkedHashMap<String, Participant>();
    private final List<Connection> connections = new ArrayList<Connection>();
    private final List<Lifeline> lifelines = new ArrayList<Lifeline>();
    private Dimension size;
    private Color connectionArrowColor;
    private Color connectionLabelColor;
    private static final Color PARTICIPANT_BACKGROUND_COLOR = _Graphics.COLOR_LIGHTER_GREEN;
    private static final Color PARTICIPANT_BORDER_COLOR = _Graphics.COLOR_DARKER_GREEN;
    private static final int PARTICIPANT_MARGIN_H = 20;
    private static final int PARTICIPANT_MARGIN_V = 5;
    private static final int PARTICIPANT_PADDING_H = 8;
    private static final int PARTICIPANT_PADDING_V = 3;
    private static final int PARTICIPANT_LINEGAP = 0;
    private static final int PARTICIPANT_MAX_CHAR_PER_LINE = 26;
    private static final Optional<Font> PARTICIPANT_FONT = _Graphics.lookupFont("Verdana", 12.0f);
    private static final Color LIFELINE_BACKGROUND_COLOR = Color.WHITE;
    private static final int LIFELINE_WIDTH = 8;
    private static final Color CONNECTION_ARROW_COLOR = _Graphics.COLOR_DARKER_RED;
    private static final Color CONNECTION_LABEL_COLOR = Color.BLACK;
    private static final int CONNECTION_MARGIN_V = 12;
    private static final int CONNECTION_LABEL_PADDING_H = 8;
    private static final int CONNECTION_LABEL_PADDING_V = 3;
    private static final int CONNECTION_LABEL_LINEGAP = 0;
    private static final Optional<Font> CONNECTION_FONT = _Graphics.lookupFont("Courier New", 11.0f);

    public SequenceDiagram alias(String id, String label) {
        this.aliases.put(id, label);
        return this;
    }

    public void enter(@NonNull String from, @NonNull String to, String label) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        Participant p0 = this.participant(from);
        Participant p1 = this.participant(to);
        this.connections.add(this.newConnection(p0, p1, label, false));
    }

    public void exit(@NonNull String from, @NonNull String to, String label) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        Participant p1 = this.participant(to);
        Participant p0 = this.participant(from);
        this.connections.add(this.newConnection(p0, p1, label, true));
    }

    public void enter(String from, String to) {
        this.enter(from, to, null);
    }

    public void exit(String from, String to) {
        this.exit(from, to, null);
    }

    public void activate(String participantId) {
        Participant participant = this.participant(participantId);
        Connection latestConnection = this.latestConnection();
        this.lifelines.add(new Lifeline(participant, latestConnection));
    }

    public void deactivate(String participantId) {
        Participant participant = this.participant(participantId);
        Connection latestConnection = this.latestConnection();
        Can.ofCollection(this.lifelines).reverse().stream().filter(lifeline -> lifeline.getParticipant().equals(participant)).findFirst().ifPresent(lifeline -> {
            lifeline.endAt = latestConnection;
        });
    }

    public void setConnectionArrowColor(Color connectionArrowColor) {
        this.connectionArrowColor = connectionArrowColor;
    }

    public void setConnectionLabelColor(Color connectionLabelColor) {
        this.connectionLabelColor = connectionLabelColor;
    }

    private Connection newConnection(Participant from, Participant to, String label, boolean dashedLine) {
        return new Connection(this.connections.size(), from, to, label, dashedLine, this.getConnectionArrowColor(), this.getConnectionLabelColor());
    }

    private Participant participant(String participantId) {
        return this.participantsById.computeIfAbsent(participantId, id -> new Participant(this.aliases.getOrDefault(id, (String)id)));
    }

    private Connection latestConnection() {
        return Can.ofCollection(this.connections).getLast().orElse(null);
    }

    private Color getConnectionArrowColor() {
        return this.connectionArrowColor != null ? this.connectionArrowColor : CONNECTION_ARROW_COLOR;
    }

    private Color getConnectionLabelColor() {
        return this.connectionLabelColor != null ? this.connectionLabelColor : CONNECTION_LABEL_COLOR;
    }

    public Dimension layout(Graphics2D g) {
        PARTICIPANT_FONT.ifPresent(g::setFont);
        _Refs.IntReference x_offset = _Refs.intRef(20);
        _Refs.IntReference y_offset = _Refs.intRef(0);
        this.participantsById.values().stream().peek(p -> p.layout(g, x_offset)).forEach(p -> y_offset.update(x -> Math.max(x, p.getHeight())));
        int width = x_offset.getValue();
        y_offset.update(x -> x + 5);
        int y_offset_first_con = y_offset.getValue();
        CONNECTION_FONT.ifPresent(g::setFont);
        this.connections.stream().forEach(c -> c.layout(g, y_offset, this.lifelines));
        int y_offset_last_con = y_offset.getValue();
        int height = y_offset.update(x -> x + 10);
        this.size = new Dimension(width, height);
        this.lifelines.stream().forEach(ll -> ll.layout(g, y_offset_first_con - 3, y_offset_last_con + 3));
        return this.size;
    }

    public void render(Graphics2D g) {
        _Graphics.enableTextAntialiasing(g);
        PARTICIPANT_FONT.ifPresent(g::setFont);
        this.participantsById.values().stream().forEach(p -> {
            g.setStroke(_Graphics.STROKE_DEFAULT);
            g.setColor(PARTICIPANT_BACKGROUND_COLOR);
            g.fillRect(p.getX_left(), p.getY_top(), p.getWidth(), p.getHeight());
            g.setColor(PARTICIPANT_BORDER_COLOR);
            g.drawRect(p.getX_left(), p.getY_top(), p.getWidth(), p.getHeight());
            g.setColor(Color.black);
            p.getTextBlock().render(g);
            g.setColor(PARTICIPANT_BORDER_COLOR);
            g.setStroke(_Graphics.STROKE_DASHED);
            g.drawLine(p.getX_middle(), p.getY_bottom(), p.getX_middle(), this.size.height - 5);
        });
        g.setStroke(_Graphics.STROKE_DEFAULT);
        this.lifelines.stream().forEach(ll -> {
            g.setColor(LIFELINE_BACKGROUND_COLOR);
            g.fillRect(ll.getX_left(), ll.getY_top(), ll.getWidth(), ll.getHeight());
            g.setColor(PARTICIPANT_BORDER_COLOR);
            g.drawRect(ll.getX_left(), ll.getY_top(), ll.getWidth(), ll.getHeight());
        });
        CONNECTION_FONT.ifPresent(g::setFont);
        this.connections.stream().forEach(c -> {
            g.setColor(c.getArrowColor());
            g.setStroke(c.isDashedLine() ? _Graphics.STROKE_DASHED : _Graphics.STROKE_DEFAULT);
            _Graphics.arrowHorizontal(g, c.getX_from(), c.getX_to(), c.getY_bottom());
            g.setColor(c.getLabelColor());
            c.getTextBlock().render(g);
        });
    }

    private static class Participant {
        final String label;
        int x_left;
        int x_middle;
        int x_right;
        int width;
        int y_top;
        int y_bottom;
        int height;
        _Graphics.TextBlock textBlock;

        void layout(Graphics2D g, _Refs.IntReference x_offset) {
            this.x_left = x_offset.getValue();
            this.y_top = 5;
            this.textBlock = new _Graphics.TextBlock(this.label, this.x_left, this.y_top);
            Dimension dim = this.textBlock.layout(g.getFontMetrics(), 8, 3, 0, 26);
            this.width = dim.width;
            this.x_right = this.x_left + this.width;
            this.x_middle = this.x_left + this.x_right >> 1;
            this.height = dim.height;
            this.y_bottom = this.y_top + this.height;
            x_offset.update(x -> x + this.width + 20);
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public int getX_left() {
            return this.x_left;
        }

        @Generated
        public int getX_middle() {
            return this.x_middle;
        }

        @Generated
        public int getX_right() {
            return this.x_right;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getY_top() {
            return this.y_top;
        }

        @Generated
        public int getY_bottom() {
            return this.y_bottom;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public _Graphics.TextBlock getTextBlock() {
            return this.textBlock;
        }

        @Generated
        public Participant(String label) {
            this.label = label;
        }
    }

    private static class Connection {
        final int index;
        final Participant from;
        final Participant to;
        final String label;
        final boolean dashedLine;
        final Color arrowColor;
        final Color labelColor;
        _Graphics.TextBlock textBlock;
        int x_left;
        int x_from;
        int x_to;
        int y_top;
        int y_bottom;
        int height;

        void layout(Graphics2D g, _Refs.IntReference y_offset, List<Lifeline> lifelines) {
            int dir;
            this.x_from = this.from.getX_middle();
            this.x_to = this.to.getX_middle();
            boolean fromConnectsLifeline = lifelines.stream().filter(ll -> ll.getParticipant().equals(this.from)).anyMatch(ll -> ll.overlaps(this));
            boolean toConnectsLifeline = lifelines.stream().filter(ll -> ll.getParticipant().equals(this.to)).anyMatch(ll -> ll.overlaps(this));
            int n = dir = this.from.getX_middle() < this.to.getX_middle() ? 1 : -1;
            if (fromConnectsLifeline) {
                this.x_from += dir * 8 / 2;
            }
            if (toConnectsLifeline) {
                this.x_to -= dir * 8 / 2;
            }
            this.x_left = Math.min(this.x_from, this.x_to);
            this.y_top = y_offset.getValue() + 12;
            this.textBlock = new _Graphics.TextBlock(this.label, this.x_left, this.y_top);
            Dimension dim = this.textBlock.layout(g.getFontMetrics(), 8, 3, 0, Integer.MAX_VALUE);
            this.height = dim.height;
            this.y_bottom = this.y_top + this.height;
            y_offset.update(x -> this.y_bottom);
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public Participant getFrom() {
            return this.from;
        }

        @Generated
        public Participant getTo() {
            return this.to;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public boolean isDashedLine() {
            return this.dashedLine;
        }

        @Generated
        public Color getArrowColor() {
            return this.arrowColor;
        }

        @Generated
        public Color getLabelColor() {
            return this.labelColor;
        }

        @Generated
        public _Graphics.TextBlock getTextBlock() {
            return this.textBlock;
        }

        @Generated
        public int getX_left() {
            return this.x_left;
        }

        @Generated
        public int getX_from() {
            return this.x_from;
        }

        @Generated
        public int getX_to() {
            return this.x_to;
        }

        @Generated
        public int getY_top() {
            return this.y_top;
        }

        @Generated
        public int getY_bottom() {
            return this.y_bottom;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public Connection(int index, Participant from, Participant to, String label, boolean dashedLine, Color arrowColor, Color labelColor) {
            this.index = index;
            this.from = from;
            this.to = to;
            this.label = label;
            this.dashedLine = dashedLine;
            this.arrowColor = arrowColor;
            this.labelColor = labelColor;
        }
    }

    private static class Lifeline {
        @NonNull
        final Participant participant;
        final Connection startAt;
        Connection endAt;
        int x_left;
        int x_right;
        int width;
        int y_top;
        int y_bottom;
        int height;

        void layout(Graphics2D g, int min_y, int max_y) {
            this.width = 8;
            this.x_left = this.participant.getX_middle() - 4;
            this.x_right = this.x_left + this.width;
            this.y_top = this.startAt != null ? this.startAt.y_bottom : min_y;
            this.y_bottom = this.endAt != null ? this.endAt.y_bottom : max_y;
            this.height = this.y_bottom - this.y_top;
        }

        public boolean overlaps(Connection connection) {
            _Ints.Bound lowerBound = _Ints.Bound.inclusive(this.startAt != null ? this.startAt.index : -1);
            _Ints.Bound upperBound = _Ints.Bound.inclusive(this.endAt != null ? this.endAt.index : Integer.MAX_VALUE);
            return _Ints.Range.of(lowerBound, upperBound).contains(connection.index);
        }

        @NonNull
        @Generated
        public Participant getParticipant() {
            return this.participant;
        }

        @Generated
        public Connection getStartAt() {
            return this.startAt;
        }

        @Generated
        public Connection getEndAt() {
            return this.endAt;
        }

        @Generated
        public int getX_left() {
            return this.x_left;
        }

        @Generated
        public int getX_right() {
            return this.x_right;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getY_top() {
            return this.y_top;
        }

        @Generated
        public int getY_bottom() {
            return this.y_bottom;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public Lifeline(@NonNull Participant participant, Connection startAt) {
            if (participant == null) {
                throw new NullPointerException("participant is marked non-null but is null");
            }
            this.participant = participant;
            this.startAt = startAt;
        }
    }
}

