/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.functions;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class _Functions {
    public static <T> Consumer<T> noopConsumer() {
        return t -> {};
    }

    public static <T> UnaryOperator<T> peek(Consumer<T> c) {
        return x -> {
            c.accept(x);
            return x;
        };
    }

    public static <T, R, U extends RuntimeException> Function<T, R> uncheckedFunction(CheckedFunction<T, R> checkedFunction, Function<Exception, U> toUncheckedException) {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <U extends RuntimeException> Runnable uncheckedRunnable(CheckedRunnable checkedRunnable, Function<Exception, U> toUncheckedException) {
        return () -> {
            try {
                checkedRunnable.run();
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static Runnable uncheckedRunnable(CheckedRunnable checkedRunnable) {
        return () -> {
            try {
                checkedRunnable.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T, U extends RuntimeException> Consumer<T> uncheckedConsumer(CheckedConsumer<T> checkedConsumer, Function<Exception, U> toUncheckedException) {
        return t -> {
            try {
                checkedConsumer.accept(t);
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <T, U, V extends RuntimeException> BiConsumer<T, U> uncheckedBiConsumer(CheckedBiConsumer<T, U> checkedBiConsumer, Function<Exception, V> toUncheckedException) {
        return (t, u) -> {
            try {
                checkedBiConsumer.accept(t, u);
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <T, U extends RuntimeException> Supplier<T> uncheckedSupplier(CheckedSupplier<T> checkedSupplier, Function<Exception, U> toUncheckedException) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Exception e) {
                throw (RuntimeException)toUncheckedException.apply(e);
            }
        };
    }

    public static <T, U extends RuntimeException> Supplier<T> uncheckedSupplier(CheckedSupplier<T> checkedSupplier) {
        return () -> {
            try {
                return checkedSupplier.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;

        default public <U extends RuntimeException> Function<T, R> toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedFunction(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Exception;

        default public <U extends RuntimeException> Runnable toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedRunnable(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;

        default public <U extends RuntimeException> Consumer<T> toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedConsumer(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;

        default public <V extends RuntimeException> BiConsumer<T, U> toUnchecked(Function<Exception, V> toUncheckedException) {
            return _Functions.uncheckedBiConsumer(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Exception;

        default public <U extends RuntimeException> Supplier<T> toUnchecked(Function<Exception, U> toUncheckedException) {
            return _Functions.uncheckedSupplier(this, toUncheckedException);
        }
    }

    @FunctionalInterface
    public static interface SerializableFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }

    @FunctionalInterface
    public static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }

    @FunctionalInterface
    public static interface SerializableConsumer<T>
    extends Consumer<T>,
    Serializable {
    }
}

