/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingSupplier;

public final class HashUtils {
    public static Try<Hash> tryDigest(@NonNull HashAlgorithm algorithm, @Nullable byte[] bytes, int buffersize) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return HashUtils.tryDigestAsBytes(algorithm, bytes, buffersize).mapSuccessAsNullable(digestBytes -> new Hash(algorithm.name(), (byte[])digestBytes));
    }

    public static Try<Hash> tryDigest(@NonNull HashAlgorithm algorithm, @NonNull DataSource dataSource, int buffersize) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        return HashUtils.tryDigestAsBytes(algorithm, dataSource, buffersize).mapSuccessAsNullable(digestBytes -> new Hash(algorithm.name(), (byte[])digestBytes));
    }

    private static Try<byte[]> tryDigestAsBytes(HashAlgorithm algorithm, byte[] bytes, int buffersize) {
        return Try.call(() -> {
            if (_NullSafe.isEmpty(bytes)) {
                return bytes;
            }
            MessageDigest messageDigest = algorithm.tryGetMessageDigest().valueAsNonNullElseFail();
            try (DigestInputStream dis = new DigestInputStream(new ByteArrayInputStream(bytes), messageDigest);){
                byte[] buffer = new byte[buffersize];
                while (dis.read(buffer) > 0) {
                }
            }
            byte[] digestBytes = messageDigest.digest();
            return digestBytes;
        });
    }

    private static Try<byte[]> tryDigestAsBytes(HashAlgorithm algorithm, DataSource dataSource, int buffersize) {
        return Try.call(() -> {
            MessageDigest messageDigest = algorithm.tryGetMessageDigest().valueAsNonNullElseFail();
            byte[] digestBytes = (byte[])dataSource.tryReadAndApply(inputStream -> {
                if (inputStream == null) {
                    return null;
                }
                try (DigestInputStream dis = new DigestInputStream((InputStream)inputStream, messageDigest);){
                    byte[] buffer = new byte[buffersize];
                    while (dis.read(buffer) > 0) {
                    }
                }
                return messageDigest.digest();
            }).valueAsNullableElseFail();
            return digestBytes;
        });
    }

    @Generated
    private HashUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum HashAlgorithm {
        MD5((ThrowingSupplier<MessageDigest>)((ThrowingSupplier)() -> MessageDigest.getInstance("MD5"))),
        SHA1((ThrowingSupplier<MessageDigest>)((ThrowingSupplier)() -> MessageDigest.getInstance("SHA-1"))),
        SHA256((ThrowingSupplier<MessageDigest>)((ThrowingSupplier)() -> MessageDigest.getInstance("SHA-256")));

        private final ThrowingSupplier<MessageDigest> messageDigestSupplier;

        public Try<MessageDigest> tryGetMessageDigest() {
            return Try.call(() -> this.getMessageDigestSupplier().get());
        }

        @Generated
        private HashAlgorithm(ThrowingSupplier<MessageDigest> messageDigestSupplier) {
            this.messageDigestSupplier = messageDigestSupplier;
        }

        @Generated
        private ThrowingSupplier<MessageDigest> getMessageDigestSupplier() {
            return this.messageDigestSupplier;
        }
    }

    public static final class Hash {
        private final String algorithmName;
        private final byte[] bytes;

        public byte[] bytes() {
            return this.bytes != null ? (byte[])this.bytes.clone() : null;
        }

        public String asHexString() {
            return _Bytes.hexDump(this.bytes, "");
        }

        @Generated
        public Hash(String algorithmName, byte[] bytes) {
            this.algorithmName = algorithmName;
            this.bytes = bytes;
        }

        @Generated
        public String algorithmName() {
            return this.algorithmName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hash)) {
                return false;
            }
            Hash other = (Hash)o;
            String this$algorithmName = this.algorithmName();
            String other$algorithmName = other.algorithmName();
            if (this$algorithmName == null ? other$algorithmName != null : !this$algorithmName.equals(other$algorithmName)) {
                return false;
            }
            return Arrays.equals(this.bytes(), other.bytes());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $algorithmName = this.algorithmName();
            result = result * 59 + ($algorithmName == null ? 43 : $algorithmName.hashCode());
            result = result * 59 + Arrays.hashCode(this.bytes());
            return result;
        }

        @Generated
        public String toString() {
            return "HashUtils.Hash(algorithmName=" + this.algorithmName() + ", bytes=" + Arrays.toString(this.bytes()) + ")";
        }
    }
}

