/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.handler;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public record ChainOfResponsibility<X, R>(String name, Can<? extends Handler<X, R>> handlers) {
    public ChainOfResponsibility(@Nullable String name, @Nullable Can<? extends Handler<X, R>> handlers) {
        this.name = _Strings.nonEmpty(name).orElse("unnamed chain");
        this.handlers = handlers != null ? handlers : Can.empty();
    }

    public ChainOfResponsibility(String name, @Nullable List<? extends Handler<X, R>> handlers) {
        this(name, Can.ofCollection(handlers));
    }

    public ChainOfResponsibility(String name, @Nullable Handler<X, R>[] handlers) {
        this(name, Can.ofArray(handlers));
    }

    public R handleElseFail(X request) {
        for (Handler handler : this.handlers) {
            if (!handler.isHandling(request)) continue;
            return Objects.requireNonNull(handler.handle(request), () -> "a handler returend null for request %s".formatted(request));
        }
        throw _Exceptions.noSuchElement("no handler found for request %s", request);
    }

    public Optional<R> handle(X request) {
        for (Handler handler : this.handlers) {
            if (!handler.isHandling(request)) continue;
            return Optional.ofNullable(handler.handle(request));
        }
        return Optional.empty();
    }

    public static interface Handler<X, R> {
        public boolean isHandling(X var1);

        public R handle(X var1);
    }
}

