/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.lang.Nullable;

public class _Multimaps {
    public static <K, V> ListMultimap<K, V> newListMultimap(final @NonNull Supplier<Map<K, List<V>>> mapFactory, final @NonNull Supplier<List<V>> elementCollectionFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        if (elementCollectionFactory == null) {
            throw new NullPointerException("elementCollectionFactory is marked non-null but is null");
        }
        return new ListMultimap<K, V>(){
            final Map<K, List<V>> delegate;
            {
                this.delegate = (Map)mapFactory.get();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public List<V> get(Object key) {
                return this.delegate.get(key);
            }

            @Override
            public List<V> put(K key, List<V> value) {
                return this.delegate.put(key, value);
            }

            @Override
            public List<V> remove(Object key) {
                return this.delegate.remove(key);
            }

            @Override
            public void putAll(Map<? extends K, ? extends List<V>> m) {
                this.delegate.putAll(m);
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<List<V>> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K, List<V>>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public void putElement(K key, V value) {
                this.getOrElseNew(key).add(value);
            }

            @Override
            public List<V> getOrElseNew(K key) {
                List collection = this.delegate.computeIfAbsent(key, arg_0 -> 1.lambda$getOrElseNew$0((Supplier)elementCollectionFactory, arg_0));
                return collection;
            }

            @Override
            public Optional<NavigableMap<K, List<V>>> asNavigableMap() {
                return this.delegate instanceof NavigableMap ? Optional.of((NavigableMap)_Casts.uncheckedCast(this.delegate)) : Optional.empty();
            }

            private static /* synthetic */ List lambda$getOrElseNew$0(Supplier elementCollectionFactory2, Object __) {
                return (List)elementCollectionFactory2.get();
            }
        };
    }

    public static <K, V, S extends Set<V>> SetMultimap<K, V> newSetMultimap(final @NonNull Supplier<? extends Map<K, S>> mapFactory, final @NonNull Supplier<S> elementCollectionFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        if (elementCollectionFactory == null) {
            throw new NullPointerException("elementCollectionFactory is marked non-null but is null");
        }
        return new SetMultimap<K, V>(){
            final Map<K, Set<V>> delegate;
            {
                this.delegate = (Map)_Casts.uncheckedCast(mapFactory.get());
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public Set<V> get(Object key) {
                return this.delegate.get(key);
            }

            @Override
            public Set<V> put(K key, Set<V> value) {
                return this.delegate.put(key, value);
            }

            @Override
            public Set<V> remove(Object key) {
                return this.delegate.remove(key);
            }

            @Override
            public void putAll(Map<? extends K, ? extends Set<V>> m) {
                this.delegate.putAll(m);
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<Set<V>> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K, Set<V>>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public void putElement(K key, V value) {
                this.getOrElseNew(key).add(value);
            }

            @Override
            public Set<V> getOrElseNew(K key) {
                Set collection = this.delegate.computeIfAbsent(key, arg_0 -> 2.lambda$getOrElseNew$0((Supplier)elementCollectionFactory, arg_0));
                return collection;
            }

            private static /* synthetic */ Set lambda$getOrElseNew$0(Supplier elementCollectionFactory2, Object __) {
                return (Set)elementCollectionFactory2.get();
            }
        };
    }

    public static <K1, K2, V> MapMultimap<K1, K2, V> newMapMultimap(final @NonNull Supplier<Map<K1, Map<K2, V>>> mapFactory, final @NonNull Supplier<Map<K2, V>> elementMapFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        if (elementMapFactory == null) {
            throw new NullPointerException("elementMapFactory is marked non-null but is null");
        }
        return new MapMultimap<K1, K2, V>(){
            final Map<K1, Map<K2, V>> delegate;
            {
                this.delegate = (Map)mapFactory.get();
            }

            @Override
            public int size() {
                return this.delegate.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegate.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return this.delegate.containsValue(value);
            }

            @Override
            public Map<K2, V> get(Object key) {
                return this.delegate.get(key);
            }

            @Override
            public Map<K2, V> put(K1 key, Map<K2, V> value) {
                return this.delegate.put(key, value);
            }

            @Override
            public Map<K2, V> remove(Object key) {
                return this.delegate.remove(key);
            }

            @Override
            public void putAll(Map<? extends K1, ? extends Map<K2, V>> m) {
                this.delegate.putAll(m);
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }

            @Override
            public Set<K1> keySet() {
                return this.delegate.keySet();
            }

            @Override
            public Collection<Map<K2, V>> values() {
                return this.delegate.values();
            }

            @Override
            public Set<Map.Entry<K1, Map<K2, V>>> entrySet() {
                return this.delegate.entrySet();
            }

            @Override
            public void putElement(K1 key, K2 subkey, V value) {
                this.getOrElseNew(key).put(subkey, value);
            }

            @Override
            public V getElement(K1 key, K2 subkey) {
                Map elementMap = this.delegate.get(key);
                return elementMap != null ? (Object)elementMap.get(subkey) : null;
            }

            @Override
            public Map<K2, V> getOrElseNew(K1 key) {
                Map elementMap = this.delegate.computeIfAbsent(key, arg_0 -> 3.lambda$getOrElseNew$0((Supplier)elementMapFactory, arg_0));
                return elementMap;
            }

            private static /* synthetic */ Map lambda$getOrElseNew$0(Supplier elementMapFactory2, Object __) {
                return (Map)elementMapFactory2.get();
            }
        };
    }

    public static <K, V> ListMultimap<K, V> newListMultimap(Supplier<List<V>> listFactory) {
        return _Multimaps.newListMultimap(HashMap::new, listFactory);
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap(Supplier<Set<V>> setFactory) {
        return _Multimaps.newSetMultimap(HashMap::new, setFactory);
    }

    public static <K, V> ListMultimap<K, V> newListMultimap() {
        return _Multimaps.newListMultimap(HashMap::new, ArrayList::new);
    }

    public static <K, V> ListMultimap<K, V> newListTreeMultimap() {
        return _Multimaps.newListMultimap(TreeMap::new, ArrayList::new);
    }

    public static <K, V> ListMultimap<K, V> newConcurrentListMultimap() {
        return _Multimaps.newListMultimap(ConcurrentHashMap::new, CopyOnWriteArrayList::new);
    }

    public static <K, V> ListMultimap<K, V> newSortedConcurrentListMultimap() {
        return _Multimaps.newListMultimap(ConcurrentSkipListMap::new, CopyOnWriteArrayList::new);
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap() {
        return _Multimaps.newSetMultimap(HashMap::new, HashSet::new);
    }

    public static <K, V> SetMultimap<K, V> newConcurrentSetMultimap() {
        return _Multimaps.newSetMultimap(ConcurrentHashMap::new, _Sets::newConcurrentHashSet);
    }

    public static <K, V> SetMultimap<K, V> newSortedSetMultimap(@Nullable Comparator<K> keyComparator, @Nullable Comparator<V> elementComparator) {
        Supplier<SortedMap> mapFactory = () -> new TreeMap(keyComparator);
        Supplier<SortedSet> elementSetFactory = () -> new TreeSet(elementComparator);
        return _Multimaps.newSetMultimap(mapFactory, elementSetFactory);
    }

    public static <K1, K2, V> MapMultimap<K1, K2, V> newMapMultimap() {
        return _Multimaps.newMapMultimap(HashMap::new, HashMap::new);
    }

    public static <K1, K2, V> MapMultimap<K1, K2, V> newConcurrentMapMultimap() {
        return _Multimaps.newMapMultimap(ConcurrentHashMap::new, HashMap::new);
    }

    public static interface ListMultimap<K, V>
    extends Map<K, List<V>> {
        public void putElement(K var1, V var2);

        public List<V> getOrElseNew(K var1);

        default public List<V> getOrElseEmpty(K key) {
            return this.getOrDefault(key, Collections.emptyList());
        }

        default public Stream<V> streamElements() {
            return this.values().stream().flatMap(Collection::stream);
        }

        default public Stream<V> streamElements(K key) {
            return this.getOrElseEmpty(key).stream();
        }

        default public Optional<NavigableMap<K, List<V>>> asNavigableMap() {
            return Optional.empty();
        }

        default public NavigableMap<K, List<V>> asNavigableMapElseFail() {
            return this.asNavigableMap().orElseThrow(() -> _Exceptions.unrecoverable("underlying map is not an instance of NavigableMap"));
        }
    }

    public static interface SetMultimap<K, V>
    extends Map<K, Set<V>> {
        public void putElement(K var1, V var2);

        public Set<V> getOrElseNew(K var1);

        default public Set<V> getOrElseEmpty(K key) {
            return this.getOrDefault(key, Collections.emptySet());
        }

        default public Stream<V> streamElements() {
            return this.values().stream().flatMap(Collection::stream);
        }
    }

    public static interface MapMultimap<K1, K2, V>
    extends Map<K1, Map<K2, V>> {
        public void putElement(K1 var1, K2 var2, V var3);

        public V getElement(K1 var1, K2 var2);

        public Map<K2, V> getOrElseNew(K1 var1);

        default public Map<K2, V> getOrElseEmpty(K1 key) {
            return this.getOrDefault(key, Collections.emptyMap());
        }

        default public Stream<V> streamElements() {
            return this.values().stream().map(Map::values).flatMap(Collection::stream);
        }
    }
}

