/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.concurrent;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.causeway.commons.concurrent.AwaitableLatch;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.concurrent._ConcurrentContext;
import org.apache.causeway.commons.internal.concurrent._ConcurrentTask;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class _ConcurrentTaskList {
    @Generated
    private static final Logger log = LogManager.getLogger(_ConcurrentTaskList.class);
    private final String name;
    private final List<_ConcurrentTask<?>> tasks = _Lists.newArrayList();
    private final AtomicBoolean wasStarted = new AtomicBoolean();
    private final CountDownLatch allFinishedLatch = new CountDownLatch(1);
    private final AwaitableLatch awaitableLatch = AwaitableLatch.of(this.allFinishedLatch);
    private final LongAdder tasksExecuted = new LongAdder();
    private long executionTimeNanos;

    public List<_ConcurrentTask<?>> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _ConcurrentTaskList addTask(_ConcurrentTask<?> task) {
        List<_ConcurrentTask<?>> list = this.tasks;
        synchronized (list) {
            if (this.wasStarted.get()) {
                String msg = "Tasks already started execution, can no longer modify collection of tasks!";
                throw new IllegalStateException(msg);
            }
            this.tasks.add(task);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _ConcurrentTaskList addTasks(Collection<? extends _ConcurrentTask<?>> tasks) {
        List<_ConcurrentTask<?>> list = this.tasks;
        synchronized (list) {
            if (this.wasStarted.get()) {
                String msg = "Tasks already started execution, can no longer modify collection of tasks!";
                throw new IllegalStateException(msg);
            }
            this.tasks.addAll(tasks);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _ConcurrentTaskList submit(final _ConcurrentContext context) {
        List<_ConcurrentTask<?>> list = this.tasks;
        synchronized (list) {
            if (this.wasStarted.get()) {
                String msg = "Tasks already started execution, can not start again!";
                throw new IllegalStateException(msg);
            }
            this.wasStarted.set(true);
        }
        final long t0 = System.nanoTime();
        if (context.shouldRunSequential()) {
            for (_ConcurrentTask<?> task : this.tasks) {
                task.run();
                this.tasksExecuted.increment();
            }
            this.executionTimeNanos = System.nanoTime() - t0;
            this.onFinished(context);
            this.allFinishedLatch.countDown();
            return this;
        }
        final ArrayList futures = new ArrayList(this.tasks.size());
        for (_ConcurrentTask<?> task : this.tasks) {
            futures.add(context.executorService.submit(task));
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (Future future : futures) {
                    try {
                        future.get();
                        _ConcurrentTaskList.this.tasksExecuted.increment();
                    }
                    catch (ExecutionException executionException) {
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                _ConcurrentTaskList.this.executionTimeNanos = System.nanoTime() - t0;
                _ConcurrentTaskList.this.onFinished(context);
                _ConcurrentTaskList.this.allFinishedLatch.countDown();
            }
        };
        thread.start();
        return this;
    }

    public AwaitableLatch latch() {
        return this.awaitableLatch;
    }

    public void await() {
        this.latch().await();
    }

    public boolean await(long timeout, TimeUnit unit) {
        return this.latch().await(timeout, unit);
    }

    public Duration getExecutionTime() {
        return Duration.of(this.executionTimeNanos, ChronoUnit.NANOS);
    }

    private void onFinished(_ConcurrentContext context) {
        for (_ConcurrentTask<?> task : this.tasks) {
            if (task.getFailedWith() == null) continue;
            log.error("----------------------------------------");
            log.error("Failed TaskList: " + this.getName());
            log.error("Failed Task: " + task.getName());
            log.error("----------------------------------------", task.getFailedWith());
        }
        if (!context.enableExecutionLogging) {
            return;
        }
        log.printf(Level.INFO, "TaskList '%s' running %d/%d tasks %s, took %.3f milliseconds ", new Object[]{this.getName(), this.tasksExecuted.longValue(), this.tasks.size(), context.shouldRunSequential() ? "sequential" : "concurrent", 1.0E-6 * (double)this.executionTimeNanos});
    }

    public _ConcurrentTaskList addRunnable(String name, Runnable runnable) {
        return this.addTask(_ConcurrentTask.of(runnable).withName(name));
    }

    public _ConcurrentTaskList submit(_ConcurrentContext._ConcurrentContextBuilder contextBuilder) {
        return this.submit(contextBuilder.build());
    }

    @Generated
    private _ConcurrentTaskList(String name) {
        this.name = name;
    }

    @Generated
    public static _ConcurrentTaskList named(String name) {
        return new _ConcurrentTaskList(name);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

