/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.functional.IndexedConsumer;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.base._Temporals;
import org.apache.causeway.commons.internal.debug.xray.XrayModel;
import org.apache.causeway.commons.internal.debug.xray._SwingUtil;
import org.apache.causeway.commons.internal.debug.xray.graphics.SequenceDiagram;

public abstract class XrayDataModel
extends XrayModel.HasIdAndLabel {
    public abstract void render(JScrollPane var1);

    @Override
    public abstract String getId();

    @Override
    public abstract String getLabel();

    public abstract String getIconResource();

    public static class Sequence
    extends XrayDataModel {
        private final SequenceDiagram data = new SequenceDiagram();
        private final String id;
        private final String label;
        @NonNull
        private final XrayModel.Stickiness stickiness;
        private final String iconResource = "/xray/sequence.png";
        private static final Color COLOR_SILVER;
        private static final Color BACKGROUND_COLOR;
        private static final Color BORDER_COLOR;

        public Sequence(String label) {
            this(UUID.randomUUID().toString(), label, XrayModel.Stickiness.CAN_DELETE_NODE);
        }

        public Sequence(String id, String label) {
            this(id, label, XrayModel.Stickiness.CAN_DELETE_NODE);
        }

        @Override
        public void render(JScrollPane panel) {
            JPanel canvas = _SwingUtil.canvas(g -> {
                g.setColor(BACKGROUND_COLOR);
                g.fill(g.getClip());
                this.data.render((Graphics2D)g);
            });
            Dimension dim = this.data.layout((Graphics2D)panel.getGraphics());
            if (BORDER_COLOR != null) {
                canvas.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
            }
            canvas.setPreferredSize(dim);
            panel.setViewportView(canvas);
        }

        @Generated
        public SequenceDiagram getData() {
            return this.data;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getLabel() {
            return this.label;
        }

        @Override
        @NonNull
        @Generated
        public XrayModel.Stickiness getStickiness() {
            return this.stickiness;
        }

        @Override
        @Generated
        public String getIconResource() {
            return this.iconResource;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sequence)) {
                return false;
            }
            Sequence other = (Sequence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            XrayModel.Stickiness this$stickiness = this.getStickiness();
            XrayModel.Stickiness other$stickiness = other.getStickiness();
            return !(this$stickiness == null ? other$stickiness != null : !((Object)((Object)this$stickiness)).equals((Object)other$stickiness));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sequence;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            XrayModel.Stickiness $stickiness = this.getStickiness();
            result = result * 59 + ($stickiness == null ? 43 : ((Object)((Object)$stickiness)).hashCode());
            return result;
        }

        @Generated
        public Sequence(String id, String label, @NonNull XrayModel.Stickiness stickiness) {
            if (stickiness == null) {
                throw new NullPointerException("stickiness is marked non-null but is null");
            }
            this.id = id;
            this.label = label;
            this.stickiness = stickiness;
        }

        static {
            BACKGROUND_COLOR = COLOR_SILVER = new Color(245, 245, 245);
            BORDER_COLOR = Color.GRAY;
        }
    }

    public static class LogEntry
    extends XrayDataModel {
        private final List<StackTraceElement> data = new ArrayList<StackTraceElement>();
        private final String id;
        private final LocalDateTime timestamp;
        private final String iconResource;
        private final String label;
        private final String logMessage;
        @NonNull
        private final XrayModel.Stickiness stickiness;

        @Override
        public void render(JScrollPane panel) {
            BorderLayout layout = new BorderLayout();
            JPanel panel2 = new JPanel(layout);
            layout.setHgap(10);
            layout.setVgap(10);
            JEditorPane logMessagePane = new JEditorPane();
            logMessagePane.setEditable(false);
            logMessagePane.setText(this.logMessage);
            JLabel timestampLabel = new JLabel(this.timestamp.format(_Temporals.DEFAULT_LOCAL_DATETIME_FORMATTER_WITH_MILLIS));
            panel2.add(_SwingUtil.verticalBox(timestampLabel, logMessagePane), "North");
            String[] columnNames = new String[]{"", "StackTraceElement"};
            Object[][] tableData = new Object[this.data.size()][columnNames.length];
            _Refs.IntReference rowIndex = _Refs.intRef(0);
            this.data.forEach(IndexedConsumer.offset(1, (index, se) -> {
                Object[] row = tableData[rowIndex.getValue()];
                rowIndex.incAndGet();
                row[0] = index;
                row[1] = se.toString();
            }));
            JTable table = _SwingUtil.newTable(tableData, columnNames);
            table.setFillsViewportHeight(true);
            panel2.add((Component)table, "Center");
            panel.setViewportView(panel2);
        }

        @Generated
        public List<StackTraceElement> getData() {
            return this.data;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        @Generated
        public String getIconResource() {
            return this.iconResource;
        }

        @Override
        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public String getLogMessage() {
            return this.logMessage;
        }

        @Override
        @NonNull
        @Generated
        public XrayModel.Stickiness getStickiness() {
            return this.stickiness;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogEntry)) {
                return false;
            }
            LogEntry other = (LogEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            LocalDateTime this$timestamp = this.getTimestamp();
            LocalDateTime other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$logMessage = this.getLogMessage();
            String other$logMessage = other.getLogMessage();
            if (this$logMessage == null ? other$logMessage != null : !this$logMessage.equals(other$logMessage)) {
                return false;
            }
            XrayModel.Stickiness this$stickiness = this.getStickiness();
            XrayModel.Stickiness other$stickiness = other.getStickiness();
            return !(this$stickiness == null ? other$stickiness != null : !((Object)((Object)this$stickiness)).equals((Object)other$stickiness));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            LocalDateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $logMessage = this.getLogMessage();
            result = result * 59 + ($logMessage == null ? 43 : $logMessage.hashCode());
            XrayModel.Stickiness $stickiness = this.getStickiness();
            result = result * 59 + ($stickiness == null ? 43 : ((Object)((Object)$stickiness)).hashCode());
            return result;
        }

        @Generated
        public LogEntry(String id, LocalDateTime timestamp, String iconResource, String label, String logMessage, @NonNull XrayModel.Stickiness stickiness) {
            if (stickiness == null) {
                throw new NullPointerException("stickiness is marked non-null but is null");
            }
            this.id = id;
            this.timestamp = timestamp;
            this.iconResource = iconResource;
            this.label = label;
            this.logMessage = logMessage;
            this.stickiness = stickiness;
        }
    }

    public static class KeyValue
    extends XrayDataModel {
        private final Map<String, String> data = new TreeMap<String, String>();
        private final String id;
        private final String label;
        @NonNull
        private final XrayModel.Stickiness stickiness;
        private final String iconResource = "/xray/key-value.png";

        @Override
        public void render(JScrollPane panel) {
            String[] columnNames = new String[]{"Key", "Value"};
            Object[][] tableData = new Object[this.data.size()][columnNames.length];
            _Refs.IntReference rowIndex = _Refs.intRef(0);
            this.data.forEach((k, v) -> {
                Object[] row = tableData[rowIndex.getValue()];
                rowIndex.incAndGet();
                row[0] = k;
                row[1] = v;
            });
            JTable table = _SwingUtil.newTable(tableData, columnNames);
            table.setFillsViewportHeight(true);
            panel.setViewportView(table);
        }

        @Generated
        public Map<String, String> getData() {
            return this.data;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getLabel() {
            return this.label;
        }

        @Override
        @NonNull
        @Generated
        public XrayModel.Stickiness getStickiness() {
            return this.stickiness;
        }

        @Override
        @Generated
        public String getIconResource() {
            return this.iconResource;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            XrayModel.Stickiness this$stickiness = this.getStickiness();
            XrayModel.Stickiness other$stickiness = other.getStickiness();
            return !(this$stickiness == null ? other$stickiness != null : !((Object)((Object)this$stickiness)).equals((Object)other$stickiness));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeyValue;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            XrayModel.Stickiness $stickiness = this.getStickiness();
            result = result * 59 + ($stickiness == null ? 43 : ((Object)((Object)$stickiness)).hashCode());
            return result;
        }

        @Generated
        public KeyValue(String id, String label, @NonNull XrayModel.Stickiness stickiness) {
            if (stickiness == null) {
                throw new NullPointerException("stickiness is marked non-null but is null");
            }
            this.id = id;
            this.label = label;
            this.stickiness = stickiness;
        }
    }
}

