/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import javax.swing.JTextArea;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.IndexedConsumer;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.debug.xray.XrayDataModel;
import org.apache.causeway.commons.internal.debug.xray.graphics.CallStackDiagram;
import org.apache.causeway.commons.internal.exceptions._Exceptions;

final class _CallStackMerger {
    private final Can<XrayDataModel.LogEntry> logEntries;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private CallStackDiagram callStackDiagram;

    void render(JTextArea textArea) {
        if (!this.initialized.get()) {
            this.initialize();
            this.initialized.set(true);
        }
        this.callStackDiagram.render(textArea);
    }

    private void initialize() {
        HashSet executionNodeSet = _Sets.newHashSet();
        HashMap executionNodeMap = _Maps.newHashMap();
        ArrayList<int[]> executionLanes = new ArrayList<int[]>();
        this.logEntries.forEach(logEntry -> {
            int[] executionLane = new int[logEntry.getData().size()];
            executionLanes.add(executionLane);
            Can.ofCollection(logEntry.getData()).reverse().stream().map(StackTraceElement::toString).forEach(IndexedConsumer.zeroBased((index, se) -> {
                boolean isNew = executionNodeSet.add(se);
                if (isNew) {
                    int id = executionNodeSet.size();
                    executionNodeMap.put(id, se);
                    executionLane[index] = id;
                } else {
                    int id;
                    executionLane[index] = id = executionNodeMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(se)).mapToInt(entry -> (Integer)entry.getKey()).findAny().orElseThrow();
                }
            }));
        });
        IntTreeNode root = _CallStackMerger.merge(executionLanes);
        this.callStackDiagram = new CallStackDiagram(root.print(id -> _Exceptions.abbreviate(executionNodeMap.getOrDefault(id, "root"), "org.apache.causeway")).toString());
    }

    static IntTreeNode merge(List<int[]> executionLanes) {
        IntTreeNode root = IntTreeNode.newRoot(-1);
        executionLanes.forEach(lane -> {
            IntTreeNode node = root;
            for (int id : lane) {
                Optional<IntTreeNode> equalNode = node.children.stream().filter(child -> child.value == id).findAny();
                node = !equalNode.isPresent() ? node.addChild(id) : equalNode.get();
            }
        });
        return root;
    }

    @Generated
    public _CallStackMerger(Can<XrayDataModel.LogEntry> logEntries) {
        this.logEntries = logEntries;
    }

    static class IntTreeNode {
        final int value;
        final int level;
        final IntTreeNode parent;
        final List<IntTreeNode> children = new ArrayList<IntTreeNode>();

        IntTreeNode addChild(int value) {
            IntTreeNode child = new IntTreeNode(value, this.level + 1, this);
            this.children.add(child);
            return child;
        }

        static IntTreeNode newRoot(int value) {
            return new IntTreeNode(value, 0, null);
        }

        void visitDepthFirst(IntTreeVisitor visitor) {
            visitor.accept(this.level, this.value);
            for (IntTreeNode child : this.children) {
                child.visitDepthFirst(visitor);
            }
        }

        void visitBreadthFirst(IntTreeVisitor visitor) {
            ArrayDeque<IntTreeNode> queue = new ArrayDeque<IntTreeNode>();
            queue.add(this);
            while (!queue.isEmpty()) {
                IntTreeNode currentNode = (IntTreeNode)queue.remove();
                visitor.accept(currentNode.level, currentNode.value);
                queue.addAll(currentNode.children);
            }
        }

        public String toString() {
            return this.print(i -> "" + i).toString();
        }

        private StringBuilder print(IntFunction<String> valueMapper) {
            StringBuilder sb = new StringBuilder();
            this.print(valueMapper, sb, "", "");
            return sb;
        }

        private void print(IntFunction<String> valueMapper, StringBuilder buffer, String prefix, String childrenPrefix) {
            buffer.append(prefix);
            buffer.append(valueMapper.apply(this.value));
            buffer.append('\n');
            Iterator<IntTreeNode> it = this.children.iterator();
            while (it.hasNext()) {
                IntTreeNode next = it.next();
                if (it.hasNext()) {
                    next.print(valueMapper, buffer, childrenPrefix + "\u251c\u2500 ", childrenPrefix + "\u2502  ");
                    continue;
                }
                next.print(valueMapper, buffer, childrenPrefix + "\u2514\u2500 ", childrenPrefix + "   ");
            }
        }

        @Generated
        public IntTreeNode(int value, int level, IntTreeNode parent) {
            this.value = value;
            this.level = level;
            this.parent = parent;
        }
    }

    static interface IntTreeVisitor {
        public void accept(int var1, int var2);
    }
}

