/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import java.util.function.Function;
import javax.imageio.ImageIO;
import lombok.NonNull;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.FileUtils;
import org.apache.causeway.commons.io.HashUtils;
import org.apache.causeway.commons.io.TextUtils;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingFunction;
import org.springframework.util.function.ThrowingSupplier;

@FunctionalInterface
public interface DataSource {
    public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> var1);

    default public <T> Try<T> tryReadAndApply(@NonNull ThrowingFunction<InputStream, T> inputStreamMapper) {
        if (inputStreamMapper == null) {
            throw new NullPointerException("inputStreamMapper is marked non-null but is null");
        }
        return this.tryReadAll(inputStream -> Try.call(() -> inputStreamMapper.apply(inputStream)));
    }

    default public Try<Void> tryReadAndAccept(@NonNull ThrowingConsumer<InputStream> inputStreamConsumer) {
        if (inputStreamConsumer == null) {
            throw new NullPointerException("inputStreamConsumer is marked non-null but is null");
        }
        return this.tryReadAll(inputStream -> Try.run(() -> inputStreamConsumer.accept(inputStream)));
    }

    default public Try<byte[]> tryReadAsBytes() {
        return this.tryReadAndApply(inputStream -> _Bytes.of(inputStream));
    }

    default public byte[] bytes() {
        return this.tryReadAsBytes().valueAsNonNullElseFail();
    }

    default public Try<String> tryReadAsString(@NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return this.tryReadAndApply(inputStream -> _Strings.ofBytes(_Bytes.of(inputStream), charset));
    }

    default public Try<String> tryReadAsStringUtf8() {
        return this.tryReadAsString(StandardCharsets.UTF_8);
    }

    default public Try<Can<String>> tryReadAsLines(@NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return this.tryReadAndApply(inputStream -> TextUtils.readLinesFromInputStream(inputStream, charset));
    }

    default public Try<Can<String>> tryReadAsLinesUtf8() {
        return this.tryReadAsLines(StandardCharsets.UTF_8);
    }

    default public Try<BufferedImage> tryReadAsImage() {
        return this.tryReadAndApply(ImageIO::read);
    }

    default public Try<HashUtils.Hash> tryHash(@NonNull HashUtils.HashAlgorithm hashAlgorithm) {
        if (hashAlgorithm == null) {
            throw new NullPointerException("hashAlgorithm is marked non-null but is null");
        }
        return HashUtils.tryDigest(hashAlgorithm, this, 4096);
    }

    default public Try<HashUtils.Hash> tryMd5() {
        return this.tryHash(HashUtils.HashAlgorithm.MD5);
    }

    default public String md5Hex() {
        return this.tryMd5().valueAsNonNullElseFail().asHexString();
    }

    default public DataSource map(final @NonNull ThrowingFunction<InputStream, InputStream> inputStreamMapper) {
        if (inputStreamMapper == null) {
            throw new NullPointerException("inputStreamMapper is marked non-null but is null");
        }
        final DataSource self = this;
        return new DataSource(){

            @Override
            public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
                if (consumingMapper == null) {
                    throw new NullPointerException("consumingMapper is marked non-null but is null");
                }
                return self.tryReadAll(is -> (Try)consumingMapper.apply((InputStream)inputStreamMapper.apply(is)));
            }

            @Override
            public String getDescription() {
                return DataSource.descriptionForMapped(self);
            }
        };
    }

    default public Try<Void> tryReadAndWrite(@NonNull DataSink dataSink, int bufferSize) {
        if (dataSink == null) {
            throw new NullPointerException("dataSink is marked non-null but is null");
        }
        return this.tryReadAndAccept((ThrowingConsumer<InputStream>)((ThrowingConsumer)inputStream -> dataSink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> {
            int n;
            byte[] buffer = new byte[bufferSize];
            while ((n = inputStream.read(buffer)) > -1) {
                os.write(buffer, 0, n);
            }
        }))));
    }

    default public void pipe(@NonNull DataSink dataSink, int bufferSize) {
        if (dataSink == null) {
            throw new NullPointerException("dataSink is marked non-null but is null");
        }
        this.tryReadAndWrite(dataSink, bufferSize).ifFailureFail();
    }

    default public void pipe(@NonNull DataSink dataSink) {
        if (dataSink == null) {
            throw new NullPointerException("dataSink is marked non-null but is null");
        }
        this.pipe(dataSink, 16384);
    }

    public static DataSource empty() {
        return new DataSource(){

            @Override
            public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
                if (consumingMapper == null) {
                    throw new NullPointerException("consumingMapper is marked non-null but is null");
                }
                return Try.empty();
            }

            @Override
            public String getDescription() {
                return DataSource.descriptionForEmpty();
            }

            public String toString() {
                return this.getDescription();
            }
        };
    }

    public static DataSource ofInputStreamSupplier(final @NonNull ThrowingSupplier<InputStream> inputStreamSupplier) {
        if (inputStreamSupplier == null) {
            throw new NullPointerException("inputStreamSupplier is marked non-null but is null");
        }
        return new DataSource(){

            @Override
            public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
                if (consumingMapper == null) {
                    throw new NullPointerException("consumingMapper is marked non-null but is null");
                }
                return Try.call(() -> {
                    try (InputStream is = (InputStream)inputStreamSupplier.get();){
                        Try try_ = (Try)consumingMapper.apply(is);
                        return try_;
                    }
                }).mapSuccessAsNullable(wrappedTry -> wrappedTry.valueAsNullableElseFail());
            }
        };
    }

    public static DataSource ofInputStreamEagerly(@Nullable InputStream inputStream) {
        return DataSource.ofBytes(_Bytes.of(inputStream));
    }

    public static DataSource ofResource(@Nullable Class<?> cls, @Nullable String resourcePath) {
        return cls == null || _Strings.isNullOrEmpty(resourcePath) ? DataSource.empty() : DataSource.ofInputStreamSupplierInternal(DataSource.descriptionForResource(cls, resourcePath), (ThrowingSupplier<InputStream>)((ThrowingSupplier)() -> cls.getResourceAsStream(resourcePath)));
    }

    public static DataSource ofSpringResource(@Nullable Resource springResource) {
        return springResource == null ? DataSource.empty() : DataSource.ofInputStreamSupplierInternal(DataSource.descriptionForResource(springResource), DataSource.fileForResource(springResource), (ThrowingSupplier<InputStream>)((ThrowingSupplier)() -> ((Resource)springResource).getInputStream()));
    }

    public static DataSource ofFile(@Nullable File file) {
        return file == null ? DataSource.empty() : DataSource.ofInputStreamSupplierInternal(DataSource.descriptionForFile(file), Optional.of(file), (ThrowingSupplier<InputStream>)((ThrowingSupplier)() -> Try.call(() -> new FileInputStream(FileUtils.existingFileElseFail(file))).valueAsNonNullElseFail()));
    }

    public static DataSource ofString(@Nullable String string, Charset charset) {
        return _Strings.isNullOrEmpty(string) ? DataSource.empty() : DataSource.ofInputStreamSupplierInternal(DataSource.descriptionForString(string), (ThrowingSupplier<InputStream>)((ThrowingSupplier)() -> new ByteArrayInputStream(string.getBytes(charset))));
    }

    public static DataSource ofStringUtf8(@Nullable String string) {
        return DataSource.ofString(string, StandardCharsets.UTF_8);
    }

    public static DataSource ofBytes(@Nullable byte[] bytes) {
        return _NullSafe.isEmpty(bytes) ? DataSource.empty() : DataSource.ofInputStreamSupplierInternal(DataSource.descriptionForBytes(bytes), (ThrowingSupplier<InputStream>)((ThrowingSupplier)() -> new ByteArrayInputStream(bytes)));
    }

    default public Optional<File> getFile() {
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void consumeAsFile(ThrowingConsumer<File> fileConsumer) {
        File file = this.getFile().orElse(null);
        if (file != null) {
            fileConsumer.accept((Object)file);
            return;
        }
        File tempFile = File.createTempFile("causeway", "ds");
        try {
            this.tryReadAndWrite(DataSink.ofFile(tempFile), 4096);
            fileConsumer.accept((Object)tempFile);
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    default public String getDescription() {
        return "";
    }

    private static DataSource ofInputStreamSupplierInternal(@NonNull String description, @NonNull ThrowingSupplier<InputStream> inputStreamSupplier) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (inputStreamSupplier == null) {
            throw new NullPointerException("inputStreamSupplier is marked non-null but is null");
        }
        return DataSource.ofInputStreamSupplierInternal(description, Optional.empty(), inputStreamSupplier);
    }

    private static DataSource ofInputStreamSupplierInternal(final @NonNull String description, final Optional<File> file, final @NonNull ThrowingSupplier<InputStream> inputStreamSupplier) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (inputStreamSupplier == null) {
            throw new NullPointerException("inputStreamSupplier is marked non-null but is null");
        }
        return new DataSource(){

            @Override
            public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
                if (consumingMapper == null) {
                    throw new NullPointerException("consumingMapper is marked non-null but is null");
                }
                return Try.call(() -> {
                    try (InputStream is = (InputStream)inputStreamSupplier.get();){
                        Try try_ = (Try)consumingMapper.apply(is);
                        return try_;
                    }
                }).mapSuccessAsNullable(wrappedTry -> wrappedTry.valueAsNullableElseFail());
            }

            @Override
            public Optional<File> getFile() {
                return file;
            }

            @Override
            public String getDescription() {
                return description;
            }

            public String toString() {
                return description;
            }
        };
    }

    private static String descriptionForEmpty() {
        return "Empty-Resource";
    }

    private static String descriptionForBytes(byte[] bytes) {
        if (bytes.length > 16) {
            byte[] sample = new byte[16];
            System.arraycopy(bytes, 0, sample, 0, sample.length);
            return String.format("Byte-Resource[%s ...]", _Bytes.hexDump(sample));
        }
        return String.format("Byte-Resource[%s]", _Bytes.hexDump(bytes));
    }

    private static String descriptionForString(String string) {
        return String.format("String-Resource[%s]", _Strings.ellipsifyAtEnd(string, 25, "..."));
    }

    private static String descriptionForResource(Resource springResource) {
        return springResource.getDescription();
    }

    private static String descriptionForResource(Class<?> cls, String resourcePath) {
        return String.format("Class-Resource[%s, %s]", cls.getName(), resourcePath);
    }

    private static String descriptionForMapped(DataSource ds) {
        return ds.getDescription() + " mapped";
    }

    private static String descriptionForFile(File file) {
        return String.format("File-Resource[%s]", file.getPath());
    }

    private static Optional<File> fileForResource(Resource springResource) {
        return springResource.isFile() ? Try.call(() -> ((Resource)springResource).getFile()).getValue() : Optional.empty();
    }
}

