/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.apache.causeway.commons.io.DataPeer;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.function.ThrowingConsumer;

public final class ZipUtils {
    public static Stream<ZipEntryDataSource> streamZipEntries(@NonNull DataSource zippedSource, @NonNull ZipOptions zipOptions) {
        if (zippedSource == null) {
            throw new NullPointerException("zippedSource is marked non-null but is null");
        }
        if (zipOptions == null) {
            throw new NullPointerException("zipOptions is marked non-null but is null");
        }
        ArrayList zipEntryDataSources = _Lists.newArrayList();
        zippedSource.consumeAsFile((ThrowingConsumer<File>)((ThrowingConsumer)zipFile -> {
            try (FileSystem fs = FileSystems.newFileSystem(zipFile.toPath());
                 Stream<Path> entries = Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0]);){
                List filesInZip = entries.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path path : filesInZip) {
                    ZipEntry zipEntry = new ZipEntry(path.toString());
                    if (!zipOptions.zipEntryFilter().test(zipEntry)) continue;
                    byte[] bytes = Files.readAllBytes(path);
                    zipEntryDataSources.add(new ZipEntryDataSource(zipEntry, bytes));
                }
            }
        }));
        return zipEntryDataSources.stream();
    }

    public static Stream<ZipEntryDataSource> streamZipEntries(@NonNull DataSource zippedSource) {
        if (zippedSource == null) {
            throw new NullPointerException("zippedSource is marked non-null but is null");
        }
        return ZipUtils.streamZipEntries(zippedSource, ZipOptions.builder().build());
    }

    public static Optional<ZipEntryDataSource> firstZipEntry(@NonNull DataSource zippedSource, @NonNull ZipOptions zipOptions) {
        if (zippedSource == null) {
            throw new NullPointerException("zippedSource is marked non-null but is null");
        }
        if (zipOptions == null) {
            throw new NullPointerException("zipOptions is marked non-null but is null");
        }
        ArrayList zipEntryDataSources = _Lists.newArrayList(1);
        zippedSource.tryReadAndAccept((ThrowingConsumer<InputStream>)((ThrowingConsumer)is -> {
            try (ZipInputStream in = new ZipInputStream((InputStream)new BufferedInputStream((InputStream)is, zipOptions.bufferSize()), zipOptions.zipEntryCharset());){
                ZipEntry zipEntry;
                while ((zipEntry = in.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipOptions.zipEntryFilter().test(zipEntry)) continue;
                    zipEntryDataSources.add(new ZipEntryDataSource(zipEntry, _Bytes.ofKeepOpen(in)));
                    return;
                }
            }
        })).ifFailureFail();
        return _Lists.firstElement(zipEntryDataSources);
    }

    public static Optional<ZipEntryDataSource> firstZipEntry(@NonNull DataSource zippedSource) {
        if (zippedSource == null) {
            throw new NullPointerException("zippedSource is marked non-null but is null");
        }
        return ZipUtils.firstZipEntry(zippedSource, ZipOptions.builder().build());
    }

    public static byte[] zipToBytes(@NonNull Stream<ZipEntryDataSource> entryStream) {
        if (entryStream == null) {
            throw new NullPointerException("entryStream is marked non-null but is null");
        }
        DataPeer buffer = DataPeer.inMemory(16384);
        ZipUtils.writeTo(entryStream, buffer);
        return buffer.bytes();
    }

    public static void writeTo(@NonNull Stream<ZipEntryDataSource> entryStream, @NonNull DataSink dataSink) {
        if (entryStream == null) {
            throw new NullPointerException("entryStream is marked non-null but is null");
        }
        if (dataSink == null) {
            throw new NullPointerException("dataSink is marked non-null but is null");
        }
        dataSink.writeAll((ThrowingConsumer<OutputStream>)((ThrowingConsumer)os -> {
            try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
                entryStream.forEach(entry -> entry.writeTo(zos));
            }
        }));
    }

    public static EntryBuilder zipEntryBuilder() {
        return new EntryBuilder();
    }

    @Generated
    private ZipUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class ZipOptions {
        private final int bufferSize;
        @NonNull
        private final Charset zipEntryCharset;
        @NonNull
        private final Predicate<ZipEntry> zipEntryFilter;

        @Generated
        private static int $default$bufferSize() {
            return 65536;
        }

        @Generated
        private static Charset $default$zipEntryCharset() {
            return StandardCharsets.UTF_8;
        }

        @Generated
        private static Predicate<ZipEntry> $default$zipEntryFilter() {
            return _Predicates.alwaysTrue();
        }

        @Generated
        ZipOptions(int bufferSize, @NonNull Charset zipEntryCharset, @NonNull Predicate<ZipEntry> zipEntryFilter) {
            if (zipEntryCharset == null) {
                throw new NullPointerException("zipEntryCharset is marked non-null but is null");
            }
            if (zipEntryFilter == null) {
                throw new NullPointerException("zipEntryFilter is marked non-null but is null");
            }
            this.bufferSize = bufferSize;
            this.zipEntryCharset = zipEntryCharset;
            this.zipEntryFilter = zipEntryFilter;
        }

        @Generated
        public static ZipOptionsBuilder builder() {
            return new ZipOptionsBuilder();
        }

        @Generated
        public int bufferSize() {
            return this.bufferSize;
        }

        @NonNull
        @Generated
        public Charset zipEntryCharset() {
            return this.zipEntryCharset;
        }

        @NonNull
        @Generated
        public Predicate<ZipEntry> zipEntryFilter() {
            return this.zipEntryFilter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZipOptions)) {
                return false;
            }
            ZipOptions other = (ZipOptions)o;
            if (this.bufferSize() != other.bufferSize()) {
                return false;
            }
            Charset this$zipEntryCharset = this.zipEntryCharset();
            Charset other$zipEntryCharset = other.zipEntryCharset();
            if (this$zipEntryCharset == null ? other$zipEntryCharset != null : !((Object)this$zipEntryCharset).equals(other$zipEntryCharset)) {
                return false;
            }
            Predicate<ZipEntry> this$zipEntryFilter = this.zipEntryFilter();
            Predicate<ZipEntry> other$zipEntryFilter = other.zipEntryFilter();
            return !(this$zipEntryFilter == null ? other$zipEntryFilter != null : !this$zipEntryFilter.equals(other$zipEntryFilter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.bufferSize();
            Charset $zipEntryCharset = this.zipEntryCharset();
            result = result * 59 + ($zipEntryCharset == null ? 43 : ((Object)$zipEntryCharset).hashCode());
            Predicate<ZipEntry> $zipEntryFilter = this.zipEntryFilter();
            result = result * 59 + ($zipEntryFilter == null ? 43 : $zipEntryFilter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZipUtils.ZipOptions(bufferSize=" + this.bufferSize() + ", zipEntryCharset=" + String.valueOf(this.zipEntryCharset()) + ", zipEntryFilter=" + String.valueOf(this.zipEntryFilter()) + ")";
        }

        @Generated
        public static class ZipOptionsBuilder {
            @Generated
            private boolean bufferSize$set;
            @Generated
            private int bufferSize$value;
            @Generated
            private boolean zipEntryCharset$set;
            @Generated
            private Charset zipEntryCharset$value;
            @Generated
            private boolean zipEntryFilter$set;
            @Generated
            private Predicate<ZipEntry> zipEntryFilter$value;

            @Generated
            ZipOptionsBuilder() {
            }

            @Generated
            public ZipOptionsBuilder bufferSize(int bufferSize) {
                this.bufferSize$value = bufferSize;
                this.bufferSize$set = true;
                return this;
            }

            @Generated
            public ZipOptionsBuilder zipEntryCharset(@NonNull Charset zipEntryCharset) {
                if (zipEntryCharset == null) {
                    throw new NullPointerException("zipEntryCharset is marked non-null but is null");
                }
                this.zipEntryCharset$value = zipEntryCharset;
                this.zipEntryCharset$set = true;
                return this;
            }

            @Generated
            public ZipOptionsBuilder zipEntryFilter(@NonNull Predicate<ZipEntry> zipEntryFilter) {
                if (zipEntryFilter == null) {
                    throw new NullPointerException("zipEntryFilter is marked non-null but is null");
                }
                this.zipEntryFilter$value = zipEntryFilter;
                this.zipEntryFilter$set = true;
                return this;
            }

            @Generated
            public ZipOptions build() {
                int bufferSize$value = this.bufferSize$value;
                if (!this.bufferSize$set) {
                    bufferSize$value = ZipOptions.$default$bufferSize();
                }
                Charset zipEntryCharset$value = this.zipEntryCharset$value;
                if (!this.zipEntryCharset$set) {
                    zipEntryCharset$value = ZipOptions.$default$zipEntryCharset();
                }
                Predicate<ZipEntry> zipEntryFilter$value = this.zipEntryFilter$value;
                if (!this.zipEntryFilter$set) {
                    zipEntryFilter$value = ZipOptions.$default$zipEntryFilter();
                }
                return new ZipOptions(bufferSize$value, zipEntryCharset$value, zipEntryFilter$value);
            }

            @Generated
            public String toString() {
                return "ZipUtils.ZipOptions.ZipOptionsBuilder(bufferSize$value=" + this.bufferSize$value + ", zipEntryCharset$value=" + String.valueOf(this.zipEntryCharset$value) + ", zipEntryFilter$value=" + String.valueOf(this.zipEntryFilter$value) + ")";
            }
        }
    }

    public static class EntryBuilder {
        private final List<ZipEntryDataSource> entries = new ArrayList<ZipEntryDataSource>();

        public EntryBuilder add(@NonNull ZipEntryDataSource zipEntryDataSource) {
            if (zipEntryDataSource == null) {
                throw new NullPointerException("zipEntryDataSource is marked non-null but is null");
            }
            this.entries.add(zipEntryDataSource);
            return this;
        }

        public EntryBuilder add(@NonNull String entryName, @Nullable byte[] bytes) {
            if (entryName == null) {
                throw new NullPointerException("entryName is marked non-null but is null");
            }
            return this.add(ZipEntryDataSource.of(new ZipEntry(entryName), bytes));
        }

        public EntryBuilder add(@NonNull String entryName, @NonNull DataSource dataSource) {
            if (entryName == null) {
                throw new NullPointerException("entryName is marked non-null but is null");
            }
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            return this.add(entryName, dataSource.bytes());
        }

        public EntryBuilder add(@NonNull String entryName, @Nullable String string, @NonNull Charset charset) {
            if (entryName == null) {
                throw new NullPointerException("entryName is marked non-null but is null");
            }
            if (charset == null) {
                throw new NullPointerException("charset is marked non-null but is null");
            }
            return this.add(entryName, _Strings.toBytes(string, charset));
        }

        public EntryBuilder addAsUtf8(@NonNull String entryName, @Nullable String string) {
            if (entryName == null) {
                throw new NullPointerException("entryName is marked non-null but is null");
            }
            return this.add(entryName, _Strings.toBytes(string, StandardCharsets.UTF_8));
        }

        public Stream<ZipEntryDataSource> stream() {
            return this.entries.stream();
        }

        public void writeTo(DataSink dataSink) {
            ZipUtils.writeTo(this.stream(), dataSink);
        }

        public byte[] toBytes() {
            return ZipUtils.zipToBytes(this.stream());
        }
    }

    public static class ZipEntryDataSource
    implements DataSource {
        private final ZipEntry zipEntry;
        private final byte[] bytes;

        @Override
        public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
            Try<T> try_;
            if (consumingMapper == null) {
                throw new NullPointerException("consumingMapper is marked non-null but is null");
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(this.bytes);
            try {
                try_ = consumingMapper.apply(bis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return Try.failure(e);
                }
            }
            bis.close();
            return try_;
        }

        public static ZipEntryDataSource of(@NonNull ZipEntry zipEntry, @Nullable byte[] bytes) {
            if (zipEntry == null) {
                throw new NullPointerException("zipEntry is marked non-null but is null");
            }
            return new ZipEntryDataSource(zipEntry, _NullSafe.toNonNull(bytes));
        }

        public static ZipEntryDataSource of(@NonNull ZipEntry zipEntry, @NonNull DataSource dataSource) {
            if (zipEntry == null) {
                throw new NullPointerException("zipEntry is marked non-null but is null");
            }
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            return ZipEntryDataSource.of(zipEntry, dataSource.bytes());
        }

        void writeTo(ZipOutputStream zipOutputStream) {
            zipOutputStream.putNextEntry(this.zipEntry());
            if (!_NullSafe.isEmpty(this.bytes)) {
                zipOutputStream.write(this.bytes);
            }
            zipOutputStream.closeEntry();
        }

        @Generated
        public ZipEntryDataSource(ZipEntry zipEntry, byte[] bytes) {
            this.zipEntry = zipEntry;
            this.bytes = bytes;
        }

        @Generated
        public ZipEntry zipEntry() {
            return this.zipEntry;
        }
    }
}

