/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Railway<F, S> {
    public static <F, S> Success<F, S> success(@Nullable S success) {
        return new Success(success);
    }

    public static <F, S> Failure<F, S> failure(@NonNull F failure) {
        return new Failure(failure);
    }

    public boolean isSuccess();

    public boolean isFailure();

    public Optional<S> getSuccess();

    default public S getSuccessElseFail() {
        return this.getSuccess().orElseThrow();
    }

    default public S getSuccessElseFail(Function<F, ? extends Throwable> toThrowable) {
        Optional<S> successIfAny = this.getSuccess();
        if (successIfAny.isPresent()) {
            return successIfAny.get();
        }
        throw toThrowable.apply(this.getFailureElseFail());
    }

    public Optional<F> getFailure();

    default public F getFailureElseFail() {
        return this.getFailure().orElseThrow();
    }

    public Railway<F, S> ifSuccess(@NonNull ThrowingConsumer<S> var1);

    public Railway<F, S> ifFailure(@NonNull ThrowingConsumer<F> var1);

    public <R> Railway<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> var1);

    public <R> Railway<R, S> mapFailure(@NonNull ThrowingFunction<F, R> var1);

    public <R> R fold(@NonNull ThrowingFunction<F, R> var1, @NonNull ThrowingFunction<S, R> var2);

    public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> var1);

    public record Success<F, S>(@NonNull S success) implements Railway<F, S>,
    Serializable
    {
        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public Optional<S> getSuccess() {
            return Optional.of(this.success);
        }

        @Override
        public Optional<F> getFailure() {
            return Optional.empty();
        }

        @Override
        public Success<F, S> ifSuccess(@NonNull ThrowingConsumer<S> successConsumer) {
            successConsumer.accept(this.success);
            return this;
        }

        @Override
        public Success<F, S> ifFailure(@NonNull ThrowingConsumer<F> failureConsumer) {
            return this;
        }

        @Override
        public <R> Success<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> successMapper) {
            return Railway.success(successMapper.apply(this.success));
        }

        @Override
        public <R> Success<R, S> mapFailure(@NonNull ThrowingFunction<F, R> failureMapper) {
            return Railway.success(this.success);
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<F, R> failureMapper, @NonNull ThrowingFunction<S, R> successMapper) {
            return (R)successMapper.apply(this.success);
        }

        @Override
        public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> chainingFunction) {
            return (Railway)chainingFunction.apply(this.success);
        }
    }

    public record Failure<F, S>(@NonNull F failure) implements Railway<F, S>,
    Serializable
    {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public Optional<S> getSuccess() {
            return Optional.empty();
        }

        @Override
        public Optional<F> getFailure() {
            return Optional.of(this.failure);
        }

        @Override
        public Failure<F, S> ifSuccess(@NonNull ThrowingConsumer<S> successConsumer) {
            return this;
        }

        @Override
        public Failure<F, S> ifFailure(@NonNull ThrowingConsumer<F> failureConsumer) {
            failureConsumer.accept(this.failure);
            return this;
        }

        @Override
        public <R> Failure<F, R> mapSuccess(@NonNull ThrowingFunction<S, R> successMapper) {
            return Railway.failure(this.failure);
        }

        @Override
        public <R> Failure<R, S> mapFailure(@NonNull ThrowingFunction<F, R> failureMapper) {
            return Railway.failure(failureMapper.apply(this.failure));
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<F, R> failureMapper, @NonNull ThrowingFunction<S, R> successMapper) {
            return (R)failureMapper.apply(this.failure);
        }

        @Override
        public Railway<F, S> chain(@NonNull ThrowingFunction<S, Railway<F, S>> chainingFunction) {
            return this;
        }
    }
}

