/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.functional;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.commons.functional.ThrowingRunnable;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Try<T> {
    public static <T> Try<T> empty() {
        return Try.success(null);
    }

    public static <T> Try<T> call(@NonNull Callable<T> callable) {
        try {
            return Try.success(callable.call());
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }

    public static Try<Void> run(@NonNull ThrowingRunnable runnable) {
        try {
            runnable.run();
            return Try.success(null);
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }

    public static <T> Success<T> success(@Nullable T value) {
        return new Success<T>(value);
    }

    public static <T> Failure<T> failure(@NonNull Throwable throwable) {
        return new Failure(throwable);
    }

    public boolean isSuccess();

    public boolean isFailure();

    public Optional<T> getValue();

    public Optional<Throwable> getFailure();

    public Try<T> ifSuccess(@NonNull ThrowingConsumer<Optional<T>> var1);

    public Try<T> ifSuccessAsNullable(@NonNull ThrowingConsumer<T> var1);

    public Try<T> ifFailure(@NonNull ThrowingConsumer<Throwable> var1);

    public Try<T> ifFailureFail();

    public Try<T> ifAbsentFail();

    public <R> Try<R> mapSuccess(@NonNull ThrowingFunction<Optional<T>, R> var1);

    public <R> Try<R> mapSuccessAsNullable(@NonNull ThrowingFunction<T, R> var1);

    public <R> Try<R> mapSuccessWhenPresent(@NonNull ThrowingFunction<T, R> var1);

    public Try<T> mapFailure(@NonNull ThrowingFunction<Throwable, Throwable> var1);

    public Try<T> mapFailureToSuccess(@NonNull ThrowingFunction<Throwable, T> var1);

    public Try<T> mapEmptyToFailure();

    public <L, R> Either<L, R> mapToEither(@NonNull ThrowingFunction<Throwable, L> var1, @NonNull ThrowingFunction<Optional<T>, R> var2);

    public <R> Try<R> flatMapSuccess(@NonNull ThrowingFunction<Optional<T>, Try<R>> var1);

    public <R> Try<R> flatMapSuccessAsNullable(@NonNull ThrowingFunction<T, Try<R>> var1);

    public <R> Try<R> flatMapSuccessWhenPresent(@NonNull ThrowingFunction<T, Try<R>> var1);

    public Try<T> accept(@NonNull ThrowingConsumer<Throwable> var1, @NonNull ThrowingConsumer<Optional<T>> var2);

    public <R> R fold(@NonNull ThrowingFunction<Throwable, R> var1, @NonNull ThrowingFunction<Optional<T>, R> var2);

    public <R> Try<R> thenCall(@NonNull Callable<R> var1);

    public Try<Void> thenRun(@NonNull ThrowingRunnable var1);

    public <R> Try<R> then(@NonNull Callable<? extends Try<R>> var1);

    public Try<T> orCall(@NonNull Callable<T> var1);

    default public @Nullable T valueAsNullableElseFail() {
        this.ifFailureFail();
        return this.getValue().orElse(null);
    }

    default public T valueAsNonNullElseFail() {
        this.ifFailureFail();
        return this.getValue().orElseThrow();
    }

    public record Success<T>(@Nullable T _value) implements Try<T>,
    Serializable
    {
        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public Optional<T> getValue() {
            return Optional.ofNullable(this._value);
        }

        @Override
        public Optional<Throwable> getFailure() {
            return Optional.empty();
        }

        @Override
        public Try<T> ifSuccess(@NonNull ThrowingConsumer<Optional<T>> valueConsumer) {
            try {
                valueConsumer.accept(this.getValue());
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Try<T> ifSuccessAsNullable(@NonNull ThrowingConsumer<T> valueConsumer) {
            try {
                valueConsumer.accept(this.getValue().orElse(null));
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Success<T> ifFailure(@NonNull ThrowingConsumer<Throwable> exceptionConsumer) {
            return this;
        }

        @Override
        public Success<T> ifFailureFail() {
            return this;
        }

        @Override
        public Success<T> ifAbsentFail() {
            if (this._value == null) {
                throw _Exceptions.noSuchElement();
            }
            return this;
        }

        @Override
        public <R> Try<R> mapSuccess(@NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            return Try.call(() -> successMapper.apply(this.getValue()));
        }

        @Override
        public <R> Try<R> mapSuccessAsNullable(@NonNull ThrowingFunction<T, R> successMapper) {
            return Try.call(() -> successMapper.apply(this.getValue().orElse(null)));
        }

        @Override
        public <R> Try<R> mapSuccessWhenPresent(@NonNull ThrowingFunction<T, R> successMapper) {
            return this.getValue().map(value -> Try.call(() -> successMapper.apply(value))).orElseGet(Try::empty);
        }

        @Override
        public <R> Try<R> flatMapSuccess(@NonNull ThrowingFunction<Optional<T>, Try<R>> successMapper) {
            try {
                return (Try)successMapper.apply(this.getValue());
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        }

        @Override
        public <R> Try<R> flatMapSuccessAsNullable(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            try {
                return (Try)successMapper.apply(this.getValue().orElse(null));
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        }

        @Override
        public <R> Try<R> flatMapSuccessWhenPresent(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            Object value = this.getValue().orElse(null);
            if (value == null) {
                return Try.empty();
            }
            try {
                return (Try)successMapper.apply(value);
            }
            catch (Throwable ex) {
                return Try.failure(ex);
            }
        }

        @Override
        public Success<T> mapFailure(@NonNull ThrowingFunction<Throwable, Throwable> failureMapper) {
            return this;
        }

        @Override
        public Try<T> mapFailureToSuccess(@NonNull ThrowingFunction<Throwable, T> recoveryMapper) {
            return this;
        }

        @Override
        public Try<T> mapEmptyToFailure() {
            return this._value != null ? this : Try.failure(_Exceptions.noSuchElement());
        }

        @Override
        public <R> Try<R> thenCall(@NonNull Callable<R> callable) {
            return Try.call(callable);
        }

        @Override
        public Try<Void> thenRun(@NonNull ThrowingRunnable runnable) {
            return Try.run(runnable);
        }

        @Override
        public <R> Try<R> then(@NonNull Callable<? extends Try<R>> next) {
            try {
                return next.call();
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Try<T> orCall(@NonNull Callable<T> fallback) {
            return this;
        }

        @Override
        public Try<T> accept(@NonNull ThrowingConsumer<Throwable> failureConsumer, @NonNull ThrowingConsumer<Optional<T>> successConsumer) {
            try {
                successConsumer.accept(this.getValue());
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<Throwable, R> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            return (R)successMapper.apply(this.getValue());
        }

        @Override
        public <L, R> Either<L, R> mapToEither(@NonNull ThrowingFunction<Throwable, L> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            return Either.right(successMapper.apply(this.getValue()));
        }
    }

    public record Failure<T>(@NonNull Throwable throwable) implements Try<T>,
    Serializable
    {
        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public Optional<T> getValue() {
            return Optional.empty();
        }

        @Override
        public Optional<Throwable> getFailure() {
            return Optional.of(this.throwable);
        }

        @Override
        public Failure<T> ifSuccess(@NonNull ThrowingConsumer<Optional<T>> valueConsumer) {
            return this;
        }

        @Override
        public Failure<T> ifSuccessAsNullable(@NonNull ThrowingConsumer<T> valueConsumer) {
            return this;
        }

        @Override
        public Failure<T> ifFailure(@NonNull ThrowingConsumer<Throwable> exceptionConsumer) {
            try {
                exceptionConsumer.accept((Object)this.throwable);
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Failure<T> ifFailureFail() {
            throw this.throwable;
        }

        @Override
        public Failure<T> ifAbsentFail() {
            throw _Exceptions.noSuchElement();
        }

        @Override
        public <R> Failure<R> mapSuccess(@NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> mapSuccessAsNullable(@NonNull ThrowingFunction<T, R> successMapper) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> mapSuccessWhenPresent(@NonNull ThrowingFunction<T, R> successMapper) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> flatMapSuccess(@NonNull ThrowingFunction<Optional<T>, Try<R>> successMapper) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> flatMapSuccessAsNullable(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public <R> Failure<R> flatMapSuccessWhenPresent(@NonNull ThrowingFunction<T, Try<R>> successMapper) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public Failure<T> mapFailure(@NonNull ThrowingFunction<Throwable, Throwable> failureMapper) {
            try {
                return new Failure<T>((Throwable)failureMapper.apply((Object)this.throwable));
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public Try<T> mapFailureToSuccess(@NonNull ThrowingFunction<Throwable, T> recoveryMapper) {
            return Try.call(() -> recoveryMapper.apply((Object)this.throwable));
        }

        @Override
        public Try<T> mapEmptyToFailure() {
            return this;
        }

        @Override
        public <R> Failure<R> thenCall(@NonNull Callable<R> callable) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public Try<Void> thenRun(@NonNull ThrowingRunnable runnable) {
            return new Failure<Void>(this.throwable);
        }

        @Override
        public <R> Try<R> then(@NonNull Callable<? extends Try<R>> next) {
            return new Failure<T>(this.throwable);
        }

        @Override
        public Try<T> orCall(@NonNull Callable<T> fallback) {
            return Try.call(fallback);
        }

        @Override
        public Try<T> accept(@NonNull ThrowingConsumer<Throwable> failureConsumer, @NonNull ThrowingConsumer<Optional<T>> successConsumer) {
            try {
                failureConsumer.accept((Object)this.throwable);
                return this;
            }
            catch (Throwable e) {
                return Try.failure(e);
            }
        }

        @Override
        public <R> R fold(@NonNull ThrowingFunction<Throwable, R> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            return (R)failureMapper.apply((Object)this.throwable);
        }

        @Override
        public <L, R> Either<L, R> mapToEither(@NonNull ThrowingFunction<Throwable, L> failureMapper, @NonNull ThrowingFunction<Optional<T>, R> successMapper) {
            return Either.left(failureMapper.apply((Object)this.throwable));
        }
    }
}

