/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Strings;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class _Temporals {
    public static final ZoneId UTC = ZoneId.of("UTC");
    public static final DateTimeFormatter DEFAULT_LOCAL_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DEFAULT_LOCAL_DATETIME_FORMATTER_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter ISO_OFFSET_ONLY_FORMAT = new DateTimeFormatterBuilder().appendOffsetId().toFormatter(Locale.US);
    public static final DateTimeFormatter DEFAULT_ZONEID_ONLY_FORMAT = new DateTimeFormatterBuilder().appendPattern("VV").toFormatter(Locale.US);
    private static final String FRACTIONAL_SECONDS_READ_PATTERN = "[.SSSSSSSSS][.SSSSSS][.SSS][.S]";
    private static final DateTimeFormatter OFFSETTIME_DATASTORE_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS XXX");
    private static final DateTimeFormatter OFFSETTIME_DATASTORE_PARSER = DateTimeFormatter.ofPattern("HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS][.S][ XXX]");
    private static final DateTimeFormatter OFFSETDATETIME_DATASTORE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS XXX");
    private static final DateTimeFormatter OFFSETDATETIME_DATASTORE_PARSER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS][.S][ XXX]");
    private static final DateTimeFormatter ZONEDDATETIME_DATASTORE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS VV");
    private static final DateTimeFormatter ZONEDDATETIME_DATASTORE_PARSER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS][.S][ VV]");
    private static final Pattern DELIMITING_WHITESPACE_PATTERN = Pattern.compile("\\s+");

    public static Optional<BigDecimal> secondsBetweenAsDecimal(@Nullable Timestamp startedAt, @Nullable Timestamp completedAt) {
        return startedAt != null && completedAt != null ? Optional.of(_Temporals.millisToSeconds(completedAt.getTime() - startedAt.getTime())) : Optional.empty();
    }

    public static ZonedDateTime translateToTimeZone(@NonNull ZonedDateTime temporal, @NonNull ZoneId zoneId) {
        return temporal.withZoneSameInstant(zoneId);
    }

    public static ZonedDateTime translateToTimeZone(@NonNull OffsetDateTime temporal, @NonNull ZoneId zoneId) {
        return ZonedDateTime.ofInstant(temporal.toInstant(), zoneId);
    }

    public static OffsetTime translateToTimeOffset(@NonNull OffsetTime temporal, @NonNull ZoneOffset offset) {
        return temporal.withOffsetSameInstant(offset);
    }

    public static String formatZoneId(ZoneId zoneId, DateTimeFormatter zoneOnlyFormatter) {
        return zoneOnlyFormatter.format(ZonedDateTime.ofInstant(Instant.EPOCH, zoneId));
    }

    public static String formatZoneId(ZoneId zoneId) {
        return _Temporals.formatZoneId(zoneId, DEFAULT_ZONEID_ONLY_FORMAT);
    }

    public static @Nullable String enstringOffsetTime(@Nullable OffsetTime temporal) {
        return temporal != null ? temporal.format(OFFSETTIME_DATASTORE_FORMATTER) : null;
    }

    public static @Nullable OffsetTime destringAsOffsetTime(@Nullable String datastoreValue) {
        return _Strings.isNotEmpty(datastoreValue) ? (_Temporals.hasZoneOrOffsetInfoWhenAssumingTimeOnly(datastoreValue) ? OffsetTime.parse(datastoreValue, OFFSETTIME_DATASTORE_PARSER) : OffsetTime.of(LocalTime.parse(datastoreValue, OFFSETTIME_DATASTORE_PARSER), ZoneOffset.UTC)) : null;
    }

    public static @Nullable String enstringOffsetDateTime(@Nullable OffsetDateTime temporal) {
        return temporal != null ? temporal.format(OFFSETDATETIME_DATASTORE_FORMATTER) : null;
    }

    public static @Nullable OffsetDateTime destringAsOffsetDateTime(@Nullable String datastoreValue) {
        return _Strings.isNotEmpty(datastoreValue) ? (_Temporals.hasZoneOrOffsetInfoWhenAssumingDateAndTime(datastoreValue) ? OffsetDateTime.parse(datastoreValue, OFFSETDATETIME_DATASTORE_PARSER) : OffsetDateTime.of(LocalDateTime.parse(datastoreValue, OFFSETDATETIME_DATASTORE_PARSER), ZoneOffset.UTC)) : null;
    }

    public static @Nullable String enstringZonedDateTime(@Nullable ZonedDateTime temporal) {
        return temporal != null ? temporal.format(ZONEDDATETIME_DATASTORE_FORMATTER) : null;
    }

    public static @Nullable ZonedDateTime destringAsZonedDateTime(@Nullable String datastoreValue) {
        return _Strings.isNotEmpty(datastoreValue) ? (_Temporals.hasZoneOrOffsetInfoWhenAssumingDateAndTime(datastoreValue) ? ZonedDateTime.parse(datastoreValue, ZONEDDATETIME_DATASTORE_PARSER) : ZonedDateTime.of(LocalDateTime.parse(datastoreValue, ZONEDDATETIME_DATASTORE_PARSER), UTC)) : null;
    }

    public static OffsetDateTime parseIsoDateTime(String isoDateTime) {
        return DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)isoDateTime, OffsetDateTime::from);
    }

    public static Can<LocalDateTime> sampleLocalDateTime() {
        return Can.of(LocalDateTime.now(), LocalDateTime.now().plusDays(2L).plusSeconds(15L));
    }

    public static Can<LocalDate> sampleLocalDate() {
        return Can.of(LocalDate.now(), LocalDate.now().plusDays(2L));
    }

    public static Can<LocalTime> sampleLocalTime() {
        return Can.of(LocalTime.now(), LocalTime.now().plusSeconds(15L));
    }

    public static Can<ZonedDateTime> sampleZonedDateTime() {
        LocalDateTime localNow = LocalDateTime.now();
        return Can.of(ZonedDateTime.of(localNow, ZoneId.of("Europe/Paris")), ZonedDateTime.of(localNow, ZoneOffset.UTC), ZonedDateTime.of(localNow, ZoneId.of("UTC")), ZonedDateTime.of(localNow, ZoneOffset.ofHours(2)), ZonedDateTime.of(localNow, ZoneOffset.ofHours(-2)).plusDays(2L).plusSeconds(15L));
    }

    public static Can<OffsetTime> sampleOffsetTime() {
        LocalTime localNow = LocalTime.now();
        return Can.of(OffsetTime.of(localNow, ZoneOffset.UTC), OffsetTime.of(localNow, ZoneOffset.ofHours(2)), OffsetTime.of(localNow, ZoneOffset.ofHours(-2)).plusSeconds(15L));
    }

    public static Can<OffsetDateTime> sampleOffsetDateTime() {
        LocalDateTime localNow = LocalDateTime.now();
        return Can.of(OffsetDateTime.of(localNow, ZoneOffset.UTC), OffsetDateTime.of(localNow, ZoneOffset.ofHours(2)), OffsetDateTime.of(localNow, ZoneOffset.ofHours(-2)).plusDays(2L).plusSeconds(15L));
    }

    private static BigDecimal millisToSeconds(long millis) {
        return new BigDecimal(millis).movePointLeft(3).setScale(3, RoundingMode.HALF_EVEN);
    }

    private static boolean hasZoneOrOffsetInfoWhenAssumingTimeOnly(@NonNull String datastoreValue) {
        return _Temporals.delimitedChunksCount(datastoreValue) > 1L;
    }

    private static boolean hasZoneOrOffsetInfoWhenAssumingDateAndTime(@NonNull String datastoreValue) {
        return _Temporals.delimitedChunksCount(datastoreValue) > 2L;
    }

    private static long delimitedChunksCount(@NonNull String datastoreValue) {
        return _Strings.splitThenStream((CharSequence)datastoreValue, DELIMITING_WHITESPACE_PATTERN).filter(_Strings::isNotEmpty).count();
    }

    @Generated
    private _Temporals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

