/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.debug.xray;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.function.Consumer;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.Generated;

final class _SwingUtil {
    static JTable newTable(Object[][] tableData, String[] columnNames) {
        JTable table = new JTable(tableData, columnNames){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component component = super.prepareRenderer(renderer, row, column);
                int rendererWidth = component.getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                tableColumn.setPreferredWidth(Math.max(rendererWidth + this.getIntercellSpacing().width, tableColumn.getPreferredWidth()));
                return component;
            }
        };
        table.setAutoResizeMode(0);
        return table;
    }

    static void setTreeExpandedState(JTree tree, boolean expanded) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        _SwingUtil.setNodeExpandedState(tree, node, expanded);
    }

    static void setNodeExpandedState(JTree tree, DefaultMutableTreeNode node, boolean expanded) {
        for (TreeNode treeNode : Collections.list(node.children())) {
            _SwingUtil.setNodeExpandedState(tree, (DefaultMutableTreeNode)treeNode, expanded);
        }
        if (!expanded && node.isRoot()) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        if (expanded) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }

    static JPanel canvas(final Consumer<Graphics2D> onRender) {
        JPanel canvas = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                onRender.accept((Graphics2D)g);
            }
        };
        return canvas;
    }

    public static Component verticalBox(Component ... components) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 6, 3, 6);
        for (Component component : components) {
            panel.add(component, gbc);
        }
        return panel;
    }

    @Generated
    private _SwingUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

