/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.hash;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class _Hashes {
    public static Optional<byte[]> digest(@NonNull Algorithm algorithm, @Nullable byte[] bytes) {
        int size = _NullSafe.size(bytes);
        if (size == 0) {
            return Optional.empty();
        }
        return algorithm.getMessageDigest().map(md -> _Hashes.digest(md, new ByteArrayInputStream(bytes), Math.max(size, 4096)));
    }

    private static byte[] digest(@NonNull MessageDigest md, @NonNull InputStream inputStream, int buffersize) {
        md.reset();
        try (DigestInputStream dis = new DigestInputStream(inputStream, md);){
            byte[] buffer = new byte[buffersize];
            while (dis.read(buffer) > 0) {
            }
        }
        return md.digest();
    }

    public static enum Algorithm {
        MD5("MD5"),
        SHA1("SHA"),
        SHA224("SHA-224"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String algorithmName;

        public Optional<MessageDigest> getMessageDigest() {
            try {
                return Optional.ofNullable(MessageDigest.getInstance(this.algorithmName));
            }
            catch (NoSuchAlgorithmException e) {
                return Optional.empty();
            }
        }

        @Generated
        private Algorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }
    }
}

