/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.ioc;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.ioc._IocContainer;
import org.apache.causeway.commons.internal.ioc._SingletonBeanProvider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.util.ClassUtils;

record _IocContainer_Spring(@NonNull ApplicationContext springContext) implements _IocContainer
{
    @Override
    public <T> Optional<T> get(@NonNull Class<T> requiredType) {
        ObjectProvider provider = this.springContext.getBeanProvider(requiredType);
        try {
            return Optional.ofNullable(provider.getIfUnique());
        }
        catch (Exception cause) {
            throw _Exceptions.unrecoverable(cause, "Failed to create an instance of type %s", requiredType);
        }
    }

    @Override
    public Stream<_SingletonBeanProvider> streamAllBeans() {
        return Stream.of(this.springContext.getBeanDefinitionNames()).map(name -> {
            Class type = ClassUtils.getUserClass((Class)this.springContext.getType(name));
            _SingletonBeanProvider beanAdapter = new _SingletonBeanProvider((String)name, type, () -> this.springContext.getBean(name));
            return beanAdapter;
        });
    }

    @Override
    public boolean containsBean(String id) {
        return this.springContext.containsBean(id);
    }

    @Override
    public Optional<?> lookupBean(String id) {
        return this.springContext.containsBean(id) ? Optional.of(this.springContext.getBean(id)) : Optional.empty();
    }

    @Override
    public <T> Can<T> select(@NonNull Class<T> requiredType) {
        Can allMatchingBeans = this.springContext.getBeanProvider(requiredType).orderedStream().collect(Can.toCan());
        return allMatchingBeans;
    }

    @Override
    public <T> Can<T> select(@NonNull Class<T> requiredType, @Nullable Annotation[] qualifiers) {
        Set<Annotation> qualifiersRequired = _IocContainer_Spring.filterQualifiers(qualifiers);
        if (_NullSafe.isEmpty(qualifiersRequired)) {
            Can allMatchingBeans = this.springContext.getBeanProvider(requiredType).orderedStream().collect(Can.toCan());
            return allMatchingBeans;
        }
        Can allMatchingBeans = this.springContext.getBeanProvider(requiredType).orderedStream().filter(t -> {
            Set<Annotation> qualifiersPresent = _Sets.of(t.getClass().getAnnotations());
            return qualifiersPresent.containsAll(qualifiersRequired);
        }).collect(Can.toCan());
        return allMatchingBeans;
    }

    private static Set<Annotation> filterQualifiers(@Nullable Annotation[] annotations) {
        if (_NullSafe.isEmpty(annotations)) {
            return Collections.emptySet();
        }
        return _NullSafe.stream(annotations).filter(_IocContainer_Spring::isGenericQualifier).collect(Collectors.toSet());
    }

    private static boolean isGenericQualifier(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        if (((Qualifier[])annotation.annotationType().getAnnotationsByType(Qualifier.class)).length > 0) {
            return true;
        }
        return annotation.annotationType().equals(Primary.class);
    }
}

