/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.primitives;

import java.util.OptionalLong;
import java.util.function.Consumer;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.primitives._Ints;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record _Longs() {
    private static final Consumer<String> IGNORE_ERRORS = t -> {};

    public static Range rangeClosed(long a, long b) {
        if (a > b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return new Range(Bound.inclusive(a), Bound.inclusive(b));
    }

    public static Range rangeOpenEnded(long a, long b) {
        if (a == b) {
            throw _Exceptions.unsupportedOperation("empty range not implemented");
        }
        if (a >= b) {
            throw _Exceptions.illegalArgument("bounds must be ordered in [%d, %d]", a, b);
        }
        return new Range(Bound.inclusive(a), Bound.exclusive(b));
    }

    public static OptionalLong parseLong(@Nullable String s, int radix, @NonNull Consumer<String> onFailure) {
        if (s == null) {
            onFailure.accept("null");
            return OptionalLong.empty();
        }
        if (radix < 2) {
            onFailure.accept("radix " + radix + " less than Character.MIN_RADIX");
            return OptionalLong.empty();
        }
        if (radix > 36) {
            onFailure.accept("radix " + radix + " greater than Character.MAX_RADIX");
            return OptionalLong.empty();
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    onFailure.accept(s);
                    return OptionalLong.empty();
                }
                if (len == 1) {
                    onFailure.accept(s);
                    return OptionalLong.empty();
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    onFailure.accept(s);
                    return OptionalLong.empty();
                }
                if (result < multmin) {
                    onFailure.accept(s);
                    return OptionalLong.empty();
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    onFailure.accept(s);
                    return OptionalLong.empty();
                }
                result -= (long)digit;
            }
        } else {
            onFailure.accept(s);
            return OptionalLong.empty();
        }
        return OptionalLong.of(negative ? result : -result);
    }

    public static long pack(int lower, int upper) {
        return (long)upper << 32 | (long)lower & 0xFFFFFFFFL;
    }

    public static void unpackAndAccept(long x, _Ints.BiIntConsumer consumer) {
        consumer.accept((int)x, (int)(x >>> 32));
    }

    public static <X> X unpackAndApply(long x, _Ints.BiIntFunction<X> function) {
        return function.apply((int)x, (int)(x >>> 32));
    }

    public static OptionalLong parseLong(String s, int radix) {
        return _Longs.parseLong(s, radix, IGNORE_ERRORS);
    }

    public record Range(@NonNull Bound lowerBound, @NonNull Bound upperBound) {
        public boolean contains(long value) {
            boolean isAboveUpper;
            boolean isBelowLower;
            boolean bl = this.lowerBound.isInclusive() ? value < this.lowerBound.value() : (isBelowLower = value <= this.lowerBound.value());
            if (isBelowLower) {
                return false;
            }
            boolean bl2 = this.upperBound.isInclusive() ? value > this.upperBound.value() : (isAboveUpper = value >= this.upperBound.value());
            return !isAboveUpper;
        }

        public long bounded(long value) {
            long nearestToUpper;
            long distanceToUpper;
            if (this.contains(value)) {
                return value;
            }
            long nearestToLower = this.nearestToLower();
            long distanceToLower = value - nearestToLower;
            return distanceToLower <= (distanceToUpper = value - (nearestToUpper = this.nearestToUpper())) ? nearestToLower : nearestToUpper;
        }

        private long nearestToLower() {
            return this.lowerBound.isInclusive() ? this.lowerBound.value() : this.lowerBound.value() + 1L;
        }

        private long nearestToUpper() {
            return this.upperBound.isInclusive() ? this.upperBound.value() : this.upperBound.value() - 1L;
        }

        @Override
        public String toString() {
            return String.format("%s%d,%d%S", Character.valueOf(this.lowerBound.isInclusive() ? (char)'[' : '('), this.lowerBound.value(), this.upperBound.value(), Character.valueOf(this.upperBound.isInclusive() ? (char)']' : ')'));
        }
    }

    public record Bound(long value, boolean isInclusive) {
        public static @NonNull Bound inclusive(long value) {
            return new Bound(value, true);
        }

        public static @NonNull Bound exclusive(long value) {
            return new Bound(value, true);
        }
    }
}

