/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.proxy;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.proxy._ProxyFactory;
import org.apache.causeway.commons.internal.proxy._ProxyFactoryService;
import org.jspecify.annotations.NonNull;

public abstract class _ProxyFactoryServiceAbstract
implements _ProxyFactoryService {
    private final @NonNull Map<Class<?>, _ProxyFactory<?>> proxyFactoryByClass = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public <T> _ProxyFactory<T> factory(Class<T> classToBeProxied, Class<?> additionalClass) {
        _ProxyFactory<T> proxyFactory = (_ProxyFactory<T>)_Casts.uncheckedCast(this.proxyFactoryByClass.get(classToBeProxied));
        if (proxyFactory == null) {
            proxyFactory = this.createFactory(classToBeProxied, additionalClass);
            this.proxyFactoryByClass.put(classToBeProxied, proxyFactory);
        }
        return proxyFactory;
    }

    private <T> _ProxyFactory<T> createFactory(Class<T> classToBeProxied, Class<?> additionalClass) {
        Class[] interfaces = _Arrays.combine(classToBeProxied.getInterfaces(), new Class[]{_ProxyFactoryService.ProxyEnhanced.class, additionalClass});
        _ProxyFactory<T> proxyFactory = _ProxyFactory.builder(classToBeProxied).interfaces(interfaces).build(this);
        return proxyFactory;
    }
}

