/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.internal.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.commons.internal._Constants;
import org.apache.causeway.commons.internal.collections._Arrays;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._GenericResolver;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class _MethodFacades {
    public static MethodFacade paramsAsTuple(@NonNull _GenericResolver.ResolvedMethod method, @NonNull _GenericResolver.ResolvedConstructor patConstructor) {
        _Reflect.guardAgainstSynthetic(method.method());
        return new ParamsAsTupleMethod(patConstructor, method);
    }

    public static MethodFacade regular(@NonNull _GenericResolver.ResolvedMethod method) {
        _Reflect.guardAgainstSynthetic(method.method());
        return new RegularMethod(method);
    }

    @Generated
    private _MethodFacades() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private record ParamsAsTupleMethod(_GenericResolver.ResolvedConstructor patConstructor, _GenericResolver.ResolvedMethod method) implements MethodFacade
    {
        @Override
        public Class<?>[] getParameterTypes() {
            return this.patConstructor.paramTypes();
        }

        @Override
        public Class<?> getParameterType(int paramNum) {
            return this.patConstructor.paramType(paramNum);
        }

        @Override
        public int getParameterCount() {
            return this.patConstructor.paramCount();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.returnType();
        }

        @Override
        public String getName() {
            return this.method.name();
        }

        @Override
        public String getParameterName(int paramNum) {
            return this.patConstructor.constructor().getParameters()[paramNum].getName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.method().getDeclaringClass();
        }

        @Override
        public Optional<_GenericResolver.ResolvedMethod> asMethod() {
            return Optional.empty();
        }

        @Override
        public Optional<_GenericResolver.ResolvedConstructor> asConstructor() {
            return Optional.of(this.patConstructor);
        }

        @Override
        public _GenericResolver.ResolvedMethod asMethodForIntrospection() {
            return this.method;
        }

        @Override
        public Executable asExecutable() {
            return this.patConstructor.constructor();
        }

        @Override
        public Object[] getArguments(Object[] executionParameters, ParameterConverter converter) {
            Object[] convertedArgs = converter.convertAll(this.patConstructor.constructor(), executionParameters);
            return new Object[]{this.patConstructor.constructor().newInstance(convertedArgs)};
        }

        @Override
        public <A extends Annotation> Optional<A> synthesize(Class<A> annotationType) {
            return _Annotations.synthesize(this.method.method(), annotationType);
        }

        @Override
        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> annotationType, int paramNum) {
            return _Annotations.synthesize(this.patConstructor.constructor().getParameters()[paramNum], annotationType);
        }

        @Override
        public boolean isAnnotatedAsNullable() {
            return this.method.streamAnnotations().map(annot -> annot.annotationType().getSimpleName()).anyMatch(name -> name.equals("Nullable"));
        }

        @Override
        public String toString() {
            return this.method.method().toString();
        }
    }

    private record RegularMethod(_GenericResolver.ResolvedMethod method) implements MethodFacade
    {
        @Override
        public Class<?> getDeclaringClass() {
            return this.method.method().getDeclaringClass();
        }

        @Override
        public int getParameterCount() {
            return this.method.paramCount();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.paramTypes();
        }

        @Override
        public Class<?> getParameterType(int paramNum) {
            return this.method.paramType(paramNum);
        }

        @Override
        public String getName() {
            return this.method.name();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.returnType();
        }

        @Override
        public Optional<_GenericResolver.ResolvedMethod> asMethod() {
            return Optional.of(this.method);
        }

        @Override
        public Optional<_GenericResolver.ResolvedConstructor> asConstructor() {
            return Optional.empty();
        }

        @Override
        public Executable asExecutable() {
            return this.method.method();
        }

        @Override
        public <A extends Annotation> Optional<A> synthesize(Class<A> annotationType) {
            return _Annotations.synthesize(this.method.method(), annotationType);
        }

        @Override
        public _GenericResolver.ResolvedMethod asMethodForIntrospection() {
            return this.method;
        }

        @Override
        public String getParameterName(int paramNum) {
            return this.method.method().getParameters()[paramNum].getName();
        }

        @Override
        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> annotationType, int paramNum) {
            return _Annotations.synthesize(this.method.method().getParameters()[paramNum], annotationType);
        }

        @Override
        public Object[] getArguments(Object[] executionParameters, ParameterConverter converter) {
            return converter.convertAll(this.method.method(), executionParameters);
        }

        @Override
        public boolean isAnnotatedAsNullable() {
            return this.method.streamAnnotations().map(annot -> annot.annotationType().getSimpleName()).anyMatch(name -> name.equals("Nullable"));
        }

        @Override
        public String toString() {
            return this.method.method().toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface MethodFacade {
        public Class<?>[] getParameterTypes();

        public Class<?> getParameterType(int var1);

        public int getParameterCount();

        public Class<?> getReturnType();

        public String getName();

        public String getParameterName(int var1);

        public Class<?> getDeclaringClass();

        public Optional<_GenericResolver.ResolvedMethod> asMethod();

        public Optional<_GenericResolver.ResolvedConstructor> asConstructor();

        public _GenericResolver.ResolvedMethod asMethodForIntrospection();

        public Executable asExecutable();

        public Object[] getArguments(Object[] var1, ParameterConverter var2);

        public <A extends Annotation> Optional<A> synthesize(Class<A> var1);

        public <A extends Annotation> Optional<A> synthesizeOnParameter(Class<A> var1, int var2);

        default public _GenericResolver.ResolvedMethod asMethodElseFail() {
            return this.asMethod().orElseThrow(() -> _Exceptions.unrecoverable("Framework Bug: unexpeced method-facade, regular variant expected: %s", this.asMethodForIntrospection()));
        }

        default public _GenericResolver.ResolvedConstructor asConstructorElseFail() {
            return this.asConstructor().orElseThrow(() -> _Exceptions.unrecoverable("Framework Bug: unexpeced method-facade, wrapper of constructor expected: %s", this.asMethodForIntrospection()));
        }

        public boolean isAnnotatedAsNullable();

        default public _GenericResolver.ResolvedType resolveMethodReturn() {
            return _GenericResolver.forMethodReturn(this.asMethodForIntrospection());
        }

        default public _GenericResolver.ResolvedType resolveParameter(int paramIndex) {
            Executable executable = this.asExecutable();
            if (executable instanceof Method) {
                return _GenericResolver.forMethodParameter(this.asMethodForIntrospection(), paramIndex);
            }
            if (executable instanceof Constructor) {
                return _GenericResolver.forConstructorParameter(this.asConstructorElseFail(), paramIndex);
            }
            throw _Exceptions.unexpectedCodeReach();
        }
    }

    @FunctionalInterface
    public static interface ParameterConverter {
        public <T> T convert(Class<T> var1, Object var2);

        default public Object[] convertAll(@NonNull Executable executable, @Nullable Object[] executionParameters) {
            int paramCount = executable.getParameterCount();
            if (paramCount == 0) {
                return _Constants.emptyObjects;
            }
            Class<?>[] parameterTypes = executable.getParameterTypes();
            Object[] adaptedExecutionParameters = new Object[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                Object origParam = _Arrays.get(executionParameters, i).orElse(null);
                adaptedExecutionParameters[i] = this.convert(parameterTypes[i], origParam);
            }
            return adaptedExecutionParameters;
        }
    }

    public static final class testing {
        public static MethodFacade regular(@NonNull Method method) {
            return _MethodFacades.regular(_GenericResolver.resolveMethod(method, method.getDeclaringClass()).orElseThrow());
        }

        @Generated
        private testing() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

