/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.commons.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.commons.io.DataSink;
import org.apache.causeway.commons.io.DataSource;
import org.jspecify.annotations.NonNull;
import org.springframework.util.function.ThrowingConsumer;

public interface DataPeer
extends DataSink,
DataSource {
    public static DataPeer inMemory() {
        return DataPeer.inMemory(32);
    }

    public static DataPeer inMemory(final int initialBufferSize) {
        final ArrayList byteArrayHolder = new ArrayList(1);
        return new DataPeer(){

            @Override
            public <T> Try<T> tryReadAll(@NonNull Function<InputStream, Try<T>> consumingMapper) {
                DataSource in = DataSource.ofBytes(this.bytes());
                return in.tryReadAll(consumingMapper);
            }

            @Override
            public void writeAll(@NonNull ThrowingConsumer<OutputStream> outputStreamConsumer) {
                if (!byteArrayHolder.isEmpty()) {
                    throw _Exceptions.illegalState("Cannot writeAll to an in-memory DataPeer, that was already written to.", new Object[0]);
                }
                DataSink out = DataSink.ofByteArrayConsumer((ThrowingConsumer<byte[]>)((ThrowingConsumer)byteArrayHolder::add), initialBufferSize);
                out.writeAll(outputStreamConsumer);
            }

            @Override
            public byte[] bytes() {
                return byteArrayHolder.isEmpty() ? new byte[]{} : (byte[])byteArrayHolder.get(0);
            }
        };
    }
}

