/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.commons.integration.changetracking;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.EntityChangeKind;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.TransactionScope;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.applib.services.iactn.Interaction;
import org.apache.causeway.applib.services.iactn.InteractionProvider;
import org.apache.causeway.applib.services.metrics.MetricsService;
import org.apache.causeway.applib.services.publishing.spi.EntityChanges;
import org.apache.causeway.applib.services.publishing.spi.EntityPropertyChange;
import org.apache.causeway.applib.services.xactn.TransactionId;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facets.object.publish.entitychange.EntityChangePublishingFacet;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.MmEntityUtils;
import org.apache.causeway.core.metamodel.services.objectlifecycle.HasEnlistedEntityPropertyChanges;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PreAndPostValue;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyChangeRecord;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyChangeRecordId;
import org.apache.causeway.core.runtime.flushmgmt.FlushMgmt;
import org.apache.causeway.core.transaction.changetracking.EntityChangeTracker;
import org.apache.causeway.core.transaction.changetracking.EntityChangesPublisher;
import org.apache.causeway.core.transaction.changetracking.EntityPropertyChangePublisher;
import org.apache.causeway.core.transaction.changetracking.HasEnlistedEntityChanges;
import org.apache.causeway.persistence.commons.integration.changetracking.PreAndPostValueEvaluatorService;
import org.apache.causeway.persistence.commons.integration.changetracking._ChangingEntitiesFactory;
import org.apache.causeway.persistence.commons.integration.changetracking._Xray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.Ordered;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;

@Service
@TransactionScope
@Named(value="causeway.persistence.commons.EntityChangeTrackerDefault")
@Qualifier(value="default")
public class EntityChangeTrackerDefault
implements MetricsService,
EntityChangeTracker,
HasEnlistedEntityPropertyChanges,
HasEnlistedEntityChanges,
TransactionSynchronization,
Ordered {
    private static final Logger log = LogManager.getLogger(EntityChangeTrackerDefault.class);
    private final EntityPropertyChangePublisher entityPropertyChangePublisher;
    private final EntityChangesPublisher entityChangesPublisher;
    private final Provider<InteractionProvider> interactionProviderProvider;
    private final PreAndPostValueEvaluatorService preAndPostValueEvaluatorService;
    private final CausewayConfiguration causewayConfiguration;
    private final Map<PropertyChangeRecordId, PropertyChangeRecord> enlistedPropertyChangeRecordsById = _Maps.newLinkedHashMap();
    private final _Lazy<Set<PropertyChangeRecord>> entityPropertyChangeRecordsForPublishing = _Lazy.threadSafe(this::capturePostValuesAndDrain);
    private final Map<Bookmark, EntityChangeKind> changeKindByEnlistedAdapter = _Maps.newLinkedHashMap();
    private final LongAdder numberEntitiesLoaded = new LongAdder();
    private final LongAdder entityChangeEventCount = new LongAdder();
    private final AtomicBoolean persistentChangesEncountered = new AtomicBoolean();
    private boolean suppressAutoFlush;

    @Programmatic
    public int getOrder() {
        return 0x1FFFFFFF;
    }

    @PostConstruct
    public void init() {
        this.suppressAutoFlush = this.causewayConfiguration.getPersistence().getCommons().getEntityChangeTracker().isSuppressAutoFlush();
    }

    public void destroy() throws Exception {
        this.enlistedPropertyChangeRecordsById.clear();
        this.entityPropertyChangeRecordsForPublishing.clear();
        this.changeKindByEnlistedAdapter.clear();
        this.numberEntitiesLoaded.reset();
        this.entityChangeEventCount.reset();
        this.persistentChangesEncountered.set(false);
    }

    private void suppressAutoFlushIfRequired(Runnable runnable) {
        if (this.suppressAutoFlush) {
            FlushMgmt.suppressAutoFlush((Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    Set<PropertyChangeRecord> snapshotPropertyChangeRecords() {
        return (Set)this.entityPropertyChangeRecordsForPublishing.get();
    }

    private Set<PropertyChangeRecord> capturePostValuesAndDrain() {
        Set records = (Set)this.enlistedPropertyChangeRecordsById.values().stream().peek(rec -> {
            if (MmEntityUtils.getEntityState((ManagedObject)rec.getEntity()).isTransientOrRemoved()) {
                rec.withPostValueSetToDeleted();
            } else {
                rec.withPostValueSetToCurrentElseUnknown();
            }
        }).filter(managedProperty -> this.shouldPublish(managedProperty.getPreAndPostValue())).collect(_Sets.toUnmodifiable());
        this.enlistedPropertyChangeRecordsById.clear();
        return records;
    }

    private boolean shouldPublish(PreAndPostValue preAndPostValue) {
        return this.preAndPostValueEvaluatorService.differ(preAndPostValue);
    }

    private boolean isEntityExcludedForChangePublishing(ManagedObject entity) {
        if (!EntityChangePublishingFacet.isPublishingEnabled((FacetHolder)entity.getSpecification())) {
            return true;
        }
        if (ManagedObjects.bookmark((ManagedObject)entity).isEmpty()) {
            return true;
        }
        if (this.entityPropertyChangeRecordsForPublishing.isMemoized()) {
            throw _Exceptions.illegalState((String)"Cannot enlist additional changes for auditing, since changedObjectPropertiesRef was already prepared (memoized) for auditing.", (Object[])new Object[0]);
        }
        return false;
    }

    public void beforeCompletion() {
        try {
            _Xray.publish(this, this.interactionProviderProvider);
            log.debug("about to publish entity changes");
            this.entityPropertyChangePublisher.publishChangedProperties();
            this.entityChangesPublisher.publishChangingEntities((HasEnlistedEntityChanges)this);
        }
        finally {
            log.debug("purging entity change records");
            this.enlistedPropertyChangeRecordsById.clear();
            this.entityPropertyChangeRecordsForPublishing.clear();
            this.changeKindByEnlistedAdapter.clear();
            this.entityChangeEventCount.reset();
            this.numberEntitiesLoaded.reset();
        }
    }

    private void enableCommandPublishing() {
        boolean alreadySet = this.persistentChangesEncountered.getAndSet(true);
        if (!alreadySet) {
            Command command = this.currentInteraction().getCommand();
        }
    }

    public Optional<EntityChanges> getEntityChanges(Timestamp timestamp, String userName) {
        return _ChangingEntitiesFactory.createChangingEntities(timestamp, userName, this);
    }

    public Can<EntityPropertyChange> getPropertyChanges(Timestamp timestamp, String userName, TransactionId txId) {
        return (Can)this.snapshotPropertyChangeRecords().stream().map(propertyChangeRecord -> propertyChangeRecord.toEntityPropertyChange(timestamp, userName, txId)).collect(Can.toCan());
    }

    Interaction currentInteraction() {
        return ((InteractionProvider)this.interactionProviderProvider.get()).currentInteractionElseFail();
    }

    private boolean enlistForChangeKindPublishing(@NonNull ManagedObject entity, @NonNull EntityChangeKind changeKind) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (changeKind == null) {
            throw new NullPointerException("changeKind is marked non-null but is null");
        }
        this.entityChangeEventCount.increment();
        this.enableCommandPublishing();
        Bookmark bookmark = ManagedObjects.bookmarkElseFail((ManagedObject)entity);
        EntityChangeKind previousChangeKind = this.changeKindByEnlistedAdapter.get(bookmark);
        if (previousChangeKind == null) {
            this.changeKindByEnlistedAdapter.put(bookmark, changeKind);
            return true;
        }
        switch (previousChangeKind) {
            case CREATE: {
                switch (changeKind) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.remove(bookmark);
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case UPDATE: {
                switch (changeKind) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.put(bookmark, changeKind);
                        return true;
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case DELETE: {
                return false;
            }
        }
        return false;
    }

    long countPotentialPropertyChangeRecords() {
        return this.enlistedPropertyChangeRecordsById.size();
    }

    public void enlistCreated(ManagedObject entity) {
        _Xray.enlistCreated(entity, this.interactionProviderProvider);
        if (this.isEntityExcludedForChangePublishing(entity)) {
            return;
        }
        this.suppressAutoFlushIfRequired(() -> {
            log.debug("enlist entity's property changes for publishing {}", (Object)entity);
            this.enlistForChangeKindPublishing(entity, EntityChangeKind.CREATE);
            MmEntityUtils.streamPropertyChangeRecordIdsForChangePublishing((ManagedObject)entity).filter(pcrId -> !this.enlistedPropertyChangeRecordsById.containsKey(pcrId)).forEach(pcrId -> this.enlistedPropertyChangeRecordsById.put((PropertyChangeRecordId)pcrId, PropertyChangeRecord.ofNew((PropertyChangeRecordId)pcrId)));
        });
    }

    public void enlistUpdating(ManagedObject entity, @Nullable Function<ManagedObject, Can<PropertyChangeRecord>> propertyChangeRecordSupplier) {
        _Xray.enlistUpdating(entity, this.interactionProviderProvider);
        if (this.isEntityExcludedForChangePublishing(entity)) {
            return;
        }
        log.debug("enlist entity's property changes for publishing {}", (Object)entity);
        this.suppressAutoFlushIfRequired(() -> {
            Can ormPropertyChangeRecords;
            this.enlistForChangeKindPublishing(entity, EntityChangeKind.UPDATE);
            Can can = ormPropertyChangeRecords = propertyChangeRecordSupplier != null ? (Can)propertyChangeRecordSupplier.apply(entity) : null;
            if (ormPropertyChangeRecords != null) {
                ormPropertyChangeRecords.stream().filter(pcr -> !this.enlistedPropertyChangeRecordsById.containsKey(pcr.getId())).forEach(pcr -> this.enlistedPropertyChangeRecordsById.put(pcr.getId(), (PropertyChangeRecord)pcr));
            } else {
                MmEntityUtils.streamPropertyChangeRecordIdsForChangePublishing((ManagedObject)entity).filter(pcrId -> !this.enlistedPropertyChangeRecordsById.containsKey(pcrId)).map(pcrId -> this.enlistedPropertyChangeRecordsById.put((PropertyChangeRecordId)pcrId, PropertyChangeRecord.ofCurrent((PropertyChangeRecordId)pcrId))).filter(Objects::nonNull).forEach(PropertyChangeRecord::withPreValueSetToCurrentElseUnknown);
            }
        });
    }

    public void enlistDeleting(ManagedObject entity) {
        _Xray.enlistDeleting(entity, this.interactionProviderProvider);
        if (this.isEntityExcludedForChangePublishing(entity)) {
            return;
        }
        this.suppressAutoFlushIfRequired(() -> {
            boolean enlisted = this.enlistForChangeKindPublishing(entity, EntityChangeKind.DELETE);
            if (enlisted) {
                log.debug("enlist entity's property changes for publishing {}", (Object)entity);
                MmEntityUtils.streamPropertyChangeRecordIdsForChangePublishing((ManagedObject)entity).forEach(pcrId -> this.enlistedPropertyChangeRecordsById.computeIfAbsent((PropertyChangeRecordId)pcrId, id -> PropertyChangeRecord.ofDeleting((PropertyChangeRecordId)id)));
            }
        });
    }

    public void incrementLoaded(ManagedObject entity) {
        _Xray.recognizeLoaded(entity, this.interactionProviderProvider);
        this.numberEntitiesLoaded.increment();
    }

    public int numberEntitiesLoaded() {
        return Math.toIntExact(this.numberEntitiesLoaded.longValue());
    }

    public int numberEntitiesDirtied() {
        return this.changeKindByEnlistedAdapter.size();
    }

    @Inject
    public EntityChangeTrackerDefault(EntityPropertyChangePublisher entityPropertyChangePublisher, EntityChangesPublisher entityChangesPublisher, Provider<InteractionProvider> interactionProviderProvider, PreAndPostValueEvaluatorService preAndPostValueEvaluatorService, CausewayConfiguration causewayConfiguration) {
        this.entityPropertyChangePublisher = entityPropertyChangePublisher;
        this.entityChangesPublisher = entityChangesPublisher;
        this.interactionProviderProvider = interactionProviderProvider;
        this.preAndPostValueEvaluatorService = preAndPostValueEvaluatorService;
        this.causewayConfiguration = causewayConfiguration;
    }

    Map<Bookmark, EntityChangeKind> getChangeKindByEnlistedAdapter() {
        return this.changeKindByEnlistedAdapter;
    }
}

