/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.bootfailureanalyzer;

import org.datanucleus.exceptions.NucleusUserException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class NonEnhancedClassesFailureAnalyzer
extends AbstractFailureAnalyzer<NucleusUserException> {
    protected FailureAnalysis analyze(Throwable rootFailure, NucleusUserException cause) {
        String msg = this.nonEnhancedMessage(cause);
        if (msg != null) {
            return new FailureAnalysis(this.descriptionOf(cause), this.action(cause), null);
        }
        return new FailureAnalysis(cause.getLocalizedMessage(), null, (Throwable)cause);
    }

    private String descriptionOf(NucleusUserException cause) {
        String buf = this.nonEnhancedMessage(cause);
        if (buf != null) {
            return buf;
        }
        return cause.getLocalizedMessage();
    }

    private String nonEnhancedMessage(NucleusUserException cause) {
        if (cause.getMessage() == null || !cause.getMessage().contains("See the nested exceptions for details")) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Non-enhanced classes:\n\n");
        for (Throwable nestedException : cause.getNestedExceptions()) {
            String prefix;
            String message = nestedException.getMessage();
            if (!message.startsWith(prefix = "Found Meta-Data for class ")) continue;
            String classNamePlusBlurb = message.substring(prefix.length());
            int spaceAfterClassName = classNamePlusBlurb.indexOf(" ");
            buf.append("  * ").append(classNamePlusBlurb, 0, spaceAfterClassName).append("\n");
        }
        return buf.toString();
    }

    private String action(NucleusUserException cause) {
        return "Did the Enhancer run correctly?";
    }
}

