/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Named;
import lombok.Generated;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnStateManagerForCauseway;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.datanucleus.PropertyNames;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@Named(value="causeway.persistence.jdo.DnSettings")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="DN6")
@ConfigurationProperties(prefix="", ignoreUnknownFields=true)
public class DatanucleusSettings {
    @Generated
    private static final Logger log = LogManager.getLogger(DatanucleusSettings.class);
    private Map<String, String> datanucleus = Collections.emptyMap();
    private Map<String, String> javax = Collections.emptyMap();
    private final Object lock = new Object();
    private Map<String, Object> properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAsProperties() {
        Object object = this.lock;
        synchronized (object) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
                if (this.datanucleus != null) {
                    this.datanucleus.forEach((k, v) -> this.properties.put(DatanucleusSettings.sanitizeKey("datanucleus." + k), v));
                }
                if (this.javax != null) {
                    this.javax.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("jdo.")).forEach(e -> this.properties.put("javax." + (String)e.getKey(), e.getValue()));
                }
                this.addFallbacks(this.properties);
            }
        }
        return this.properties;
    }

    private void addFallbacks(Map<String, Object> props) {
        String connectionFactoryName = (String)props.get(PropertyNames.PROPERTY_CONNECTION_FACTORY_NAME);
        if (connectionFactoryName != null) {
            String connectionFactory2Name = (String)props.get(PropertyNames.PROPERTY_CONNECTION_FACTORY2_NAME);
            String transactionType = (String)props.get("javax.jdo.option.TransactionType".toLowerCase());
            if (transactionType == null) {
                log.info("found config properties to use non-JTA JNDI datasource ({})", (Object)connectionFactoryName);
                if (connectionFactory2Name != null) {
                    log.warn("found config properties to use non-JTA JNDI datasource ({}); second '-nontx' JNDI datasource also configured but will not be used ({})", (Object)connectionFactoryName, (Object)connectionFactory2Name);
                }
            } else {
                log.info("found config properties to use JTA JNDI datasource ({})", (Object)connectionFactoryName);
            }
            if (connectionFactory2Name == null) {
                log.error("found config properties to use JTA JNDI datasource ({}) but config properties for second '-nontx' JNDI datasource were *not* found", (Object)connectionFactoryName);
            } else {
                log.info("... and config properties for second '-nontx' JNDI datasource also found; {}", (Object)connectionFactory2Name);
            }
        }
        props.computeIfAbsent("datanucleus.statemanager.classname", key -> DnStateManagerForCauseway.class.getName());
    }

    private static String sanitizeKey(String key) {
        return key.replaceAll("-", "").toLowerCase();
    }

    @Generated
    public Map<String, String> getDatanucleus() {
        return this.datanucleus;
    }

    @Generated
    public void setDatanucleus(Map<String, String> datanucleus) {
        this.datanucleus = datanucleus;
    }

    @Generated
    public Map<String, String> getJavax() {
        return this.javax;
    }

    @Generated
    public void setJavax(Map<String, String> javax) {
        this.javax = javax;
    }
}

