/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Priority;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class JdoObjectIdentityValueSemantics
extends ValueSemanticsBasedOnIdStringifier<ObjectIdentity> {
    private static final String PREFIX_UUID = "u_";
    private static final String PREFIX_LONG = "l_";
    private static final String PREFIX_INT = "i_";

    public JdoObjectIdentityValueSemantics() {
        super(ObjectIdentity.class);
    }

    public ValueDecomposition decompose(ObjectIdentity value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldIdentity::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public ObjectIdentity compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull ObjectIdentity value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Object keyAsObject = value.getKeyAsObject();
        if (keyAsObject instanceof Long) {
            return PREFIX_LONG + keyAsObject;
        }
        if (keyAsObject instanceof Integer) {
            return PREFIX_INT + keyAsObject;
        }
        if (keyAsObject instanceof UUID) {
            return PREFIX_UUID + keyAsObject;
        }
        return keyAsObject.toString();
    }

    public ObjectIdentity destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        if (stringified.startsWith(PREFIX_LONG)) {
            return new ObjectIdentity(targetEntityClass, (Object)Long.parseLong(stringified.substring(PREFIX_LONG.length())));
        }
        if (stringified.startsWith(PREFIX_INT)) {
            return new ObjectIdentity(targetEntityClass, (Object)Integer.parseInt(stringified.substring(PREFIX_INT.length())));
        }
        if (stringified.startsWith(PREFIX_UUID)) {
            return new ObjectIdentity(targetEntityClass, (Object)UUID.fromString(stringified.substring(PREFIX_UUID.length())));
        }
        return new ObjectIdentity(targetEntityClass, (Object)stringified);
    }

    @Generated
    public static JdoObjectIdentityValueSemanticsBuilder builder() {
        return new JdoObjectIdentityValueSemanticsBuilder();
    }

    @Generated
    public static class JdoObjectIdentityValueSemanticsBuilder {
        @Generated
        JdoObjectIdentityValueSemanticsBuilder() {
        }

        @Generated
        public JdoObjectIdentityValueSemantics build() {
            return new JdoObjectIdentityValueSemantics();
        }

        @Generated
        public String toString() {
            return "JdoObjectIdentityValueSemantics.JdoObjectIdentityValueSemanticsBuilder()";
        }
    }
}

