/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.changetracking;

import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.Domain;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.services.objectlifecycle.ObjectLifecyclePublisher;
import org.apache.causeway.persistence.jdo.datanucleus.changetracking._Utils;
import org.apache.causeway.persistence.jdo.datanucleus.entities.DnStateManagerForCauseway;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.datanucleus.enhancement.Persistable;

@Domain.Exclude
public class JdoLifecycleListener
implements AttachLifecycleListener,
ClearLifecycleListener,
CreateLifecycleListener,
DeleteLifecycleListener,
DetachLifecycleListener,
DirtyLifecycleListener,
LoadLifecycleListener,
StoreLifecycleListener {
    private static final Logger log = LogManager.getLogger(JdoLifecycleListener.class);
    @NonNull
    private final MetaModelContext metaModelContext;
    @NonNull
    private final ObjectLifecyclePublisher objectLifecyclePublisher;

    public void postCreate(InstanceLifecycleEvent event) {
        log.debug("postCreate {}", new Supplier[]{() -> _Utils.debug(event)});
        _Utils.resolveInjectionPoints(this.metaModelContext, event);
    }

    public void preAttach(InstanceLifecycleEvent event) {
        log.debug("preAttach {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void postAttach(InstanceLifecycleEvent event) {
        log.debug("postAttach {}", new Supplier[]{() -> _Utils.debug(event)});
        _Utils.resolveInjectionPoints(this.metaModelContext, event);
    }

    public void postLoad(InstanceLifecycleEvent event) {
        log.debug("postLoad {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        ManagedObject entity = this.adaptEntity(pojo);
        this.objectLifecyclePublisher.onPostLoad(entity);
    }

    public void preStore(InstanceLifecycleEvent event) {
        log.debug("preStore {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        boolean isInserting = this.isInserting(pojo);
        ManagedObject entity = this.adaptEntity(pojo);
        if (isInserting) {
            this.objectLifecyclePublisher.onPrePersist(entity.asEitherWithOrWithoutMemoizedBookmark());
        }
    }

    public void postStore(InstanceLifecycleEvent event) {
        log.debug("postStore {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        boolean isInserting = this.isInserting(pojo);
        ManagedObject entity = this.adaptEntity(pojo);
        if (isInserting) {
            this.objectLifecyclePublisher.onPostPersist(entity);
        } else {
            this.objectLifecyclePublisher.onPostUpdate(entity);
        }
    }

    public void preDirty(InstanceLifecycleEvent event) {
        log.debug("preDirty {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        Runnable doPreDirty = () -> this.doPreDirty(pojo);
        DnStateManagerForCauseway.extractFrom(pojo).ifPresentOrElse(stateManager -> stateManager.acquirePreDirtyPropagationLock(pojo.dnGetObjectId()).ifPresent(lock -> lock.releaseAfter(doPreDirty)), doPreDirty);
    }

    private final void doPreDirty(Persistable pojo) {
        ManagedObject entity = this.adaptEntity(pojo);
        this.objectLifecyclePublisher.onPreUpdate(entity, null);
    }

    public void postDirty(InstanceLifecycleEvent event) {
    }

    public void preDelete(InstanceLifecycleEvent event) {
        log.debug("preDelete {}", new Supplier[]{() -> _Utils.debug(event)});
        Persistable pojo = _Utils.persistableFor(event);
        _Assert.assertNotNull((Object)pojo.dnGetObjectId());
        ManagedObject entity = this.adaptEntity(pojo);
        this.objectLifecyclePublisher.onPreRemove(entity);
    }

    public void postDelete(InstanceLifecycleEvent event) {
        log.debug("postDelete {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void preClear(InstanceLifecycleEvent event) {
        log.debug("preClear {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void postClear(InstanceLifecycleEvent event) {
        log.debug("postClear {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void preDetach(InstanceLifecycleEvent event) {
        log.debug("preDetach {}", new Supplier[]{() -> _Utils.debug(event)});
    }

    public void postDetach(InstanceLifecycleEvent event) {
        log.debug("postDetach {}", new Supplier[]{() -> _Utils.debug(event)});
        _Utils.resolveInjectionPoints(this.metaModelContext, event);
    }

    private ManagedObject adaptEntity(@NonNull Persistable pojo) {
        if (pojo == null) {
            throw new NullPointerException("pojo is marked non-null but is null");
        }
        return _Utils.adaptEntity(this.metaModelContext, pojo);
    }

    private boolean isInserting(@NonNull Persistable pojo) {
        if (pojo == null) {
            throw new NullPointerException("pojo is marked non-null but is null");
        }
        return DnStateManagerForCauseway.extractFrom(pojo).map(DnStateManagerForCauseway::isInsertingOrInsertingCallbacks).orElse(false);
    }

    public JdoLifecycleListener(@NonNull MetaModelContext metaModelContext, @NonNull ObjectLifecyclePublisher objectLifecyclePublisher) {
        if (metaModelContext == null) {
            throw new NullPointerException("metaModelContext is marked non-null but is null");
        }
        if (objectLifecyclePublisher == null) {
            throw new NullPointerException("objectLifecyclePublisher is marked non-null but is null");
        }
        this.metaModelContext = metaModelContext;
        this.objectLifecyclePublisher = objectLifecyclePublisher;
    }
}

