/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import java.util.Map;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.IdStringifier;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class JdoCharIdentityValueSemantics
extends ValueSemanticsBasedOnIdStringifier<CharIdentity> {
    @Inject
    IdStringifier<Character> idStringifierForCharacter;

    public JdoCharIdentityValueSemantics() {
        super(CharIdentity.class);
    }

    JdoCharIdentityValueSemantics(IdStringifier<Character> idStringifierForCharacter) {
        this();
        this.idStringifierForCharacter = idStringifierForCharacter;
    }

    public ValueDecomposition decompose(CharIdentity value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldIdentity::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public CharIdentity compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull CharIdentity value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.idStringifierForCharacter.enstring((Object)Character.valueOf(value.getKey()));
    }

    public CharIdentity destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        Character idValue = (Character)this.idStringifierForCharacter.destring(targetEntityClass, stringified);
        return new CharIdentity(targetEntityClass, idValue);
    }

    public static JdoCharIdentityValueSemanticsBuilder builder() {
        return new JdoCharIdentityValueSemanticsBuilder();
    }

    public static class JdoCharIdentityValueSemanticsBuilder {
        private IdStringifier<Character> idStringifierForCharacter;

        JdoCharIdentityValueSemanticsBuilder() {
        }

        public JdoCharIdentityValueSemanticsBuilder idStringifierForCharacter(IdStringifier<Character> idStringifierForCharacter) {
            this.idStringifierForCharacter = idStringifierForCharacter;
            return this;
        }

        public JdoCharIdentityValueSemantics build() {
            return new JdoCharIdentityValueSemantics(this.idStringifierForCharacter);
        }

        public String toString() {
            return "JdoCharIdentityValueSemantics.JdoCharIdentityValueSemanticsBuilder(idStringifierForCharacter=" + this.idStringifierForCharacter + ")";
        }
    }
}

