/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.IdStringifier;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.datanucleus.identity.CharId;
import org.datanucleus.identity.SingleFieldId;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class DnCharIdValueSemantics
extends ValueSemanticsBasedOnIdStringifier<CharId> {
    @Inject
    IdStringifier<Character> idStringifierForCharacter;

    public DnCharIdValueSemantics() {
        super(CharId.class);
    }

    DnCharIdValueSemantics(IdStringifier<Character> idStringifierForCharacter) {
        this();
        this.idStringifierForCharacter = idStringifierForCharacter;
    }

    public ValueDecomposition decompose(CharId value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldId::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public CharId compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull CharId value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.idStringifierForCharacter.enstring((Object)Character.valueOf(value.getKey()));
    }

    public CharId destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        Character idValue = (Character)this.idStringifierForCharacter.destring(targetEntityClass, stringified);
        return new CharId(targetEntityClass, idValue);
    }

    @Generated
    public static DnCharIdValueSemanticsBuilder builder() {
        return new DnCharIdValueSemanticsBuilder();
    }

    @Generated
    public static class DnCharIdValueSemanticsBuilder {
        @Generated
        private IdStringifier<Character> idStringifierForCharacter;

        @Generated
        DnCharIdValueSemanticsBuilder() {
        }

        @Generated
        public DnCharIdValueSemanticsBuilder idStringifierForCharacter(IdStringifier<Character> idStringifierForCharacter) {
            this.idStringifierForCharacter = idStringifierForCharacter;
            return this;
        }

        @Generated
        public DnCharIdValueSemantics build() {
            return new DnCharIdValueSemantics(this.idStringifierForCharacter);
        }

        @Generated
        public String toString() {
            return "DnCharIdValueSemantics.DnCharIdValueSemanticsBuilder(idStringifierForCharacter=" + this.idStringifierForCharacter + ")";
        }
    }
}

