/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.valuetypes;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.services.bookmark.IdStringifier;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifier;
import org.apache.causeway.commons.internal.factory._InstanceUtil;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.identity.StringId;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class DnStringIdValueSemantics
extends ValueSemanticsBasedOnIdStringifier<StringId> {
    @Inject
    IdStringifier<String> idStringifierForString;

    public DnStringIdValueSemantics() {
        super(StringId.class);
    }

    DnStringIdValueSemantics(IdStringifier<String> idStringifierForString) {
        this();
        this.idStringifierForString = idStringifierForString;
    }

    public ValueDecomposition decompose(StringId value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.STRING, "targetClassName", SingleFieldId::getTargetClassName).addFundamentalType(ValueType.STRING, "key", this::enstring).buildAsDecomposition();
    }

    public StringId compose(ValueDecomposition decomposition) {
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)((TypedTupleDto)decomposition.rightIfAny()));
        String targetClassName = (String)elementMap.get("targetClassName");
        String key = (String)elementMap.get("key");
        return this.destring(_InstanceUtil.loadClass((String)targetClassName), key);
    }

    public String enstring(@NonNull StringId value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.idStringifierForString.enstring((Object)value.getKey());
    }

    public StringId destring(@NonNull Class<?> targetEntityClass, @NonNull String stringified) {
        if (targetEntityClass == null) {
            throw new NullPointerException("targetEntityClass is marked non-null but is null");
        }
        if (stringified == null) {
            throw new NullPointerException("stringified is marked non-null but is null");
        }
        String idValue = (String)this.idStringifierForString.destring(targetEntityClass, stringified);
        return new StringId(targetEntityClass, idValue);
    }

    @Generated
    public static DnStringIdValueSemanticsBuilder builder() {
        return new DnStringIdValueSemanticsBuilder();
    }

    @Generated
    public static class DnStringIdValueSemanticsBuilder {
        @Generated
        private IdStringifier<String> idStringifierForString;

        @Generated
        DnStringIdValueSemanticsBuilder() {
        }

        @Generated
        public DnStringIdValueSemanticsBuilder idStringifierForString(IdStringifier<String> idStringifierForString) {
            this.idStringifierForString = idStringifierForString;
            return this;
        }

        @Generated
        public DnStringIdValueSemantics build() {
            return new DnStringIdValueSemantics(this.idStringifierForString);
        }

        @Generated
        public String toString() {
            return "DnStringIdValueSemantics.DnStringIdValueSemanticsBuilder(idStringifierForString=" + String.valueOf(this.idStringifierForString) + ")";
        }
    }
}

