/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.entities;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.causeway.applib.services.repository.EntityState;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Sets;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facets.object.entity.EntityFacet;
import org.apache.causeway.persistence.jdo.datanucleus.metamodel.facets.entity.JdoEntityFacet;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;
import org.datanucleus.enhancement.Persistable;
import org.jspecify.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class DnEntityStateProvider
implements JdoFacetContext {
    private static final Set<String> jdoMethodsProvidedByEnhancement = _Sets.newHashSet();

    public EntityState getEntityState(Object pojo) {
        return DnEntityStateProvider.entityState(pojo);
    }

    public boolean isPersistenceEnhanced(@Nullable Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Persistable.class.isAssignableFrom(cls);
    }

    public boolean isMethodProvidedByEnhancement(@Nullable Method method) {
        if (method == null) {
            return false;
        }
        DnEntityStateProvider.ensureInit();
        return jdoMethodsProvidedByEnhancement.contains(method.toString());
    }

    public static EntityState entityState(Object pojo) {
        if (pojo == null || !(pojo instanceof Persistable)) {
            return EntityState.NOT_PERSISTABLE;
        }
        Persistable persistable = (Persistable)pojo;
        boolean isDeleted = persistable.dnIsDeleted();
        if (isDeleted) {
            return EntityState.REMOVED;
        }
        boolean isPersistent = persistable.dnIsPersistent();
        if (isPersistent) {
            Object oid = persistable.dnGetObjectId();
            return oid != null ? EntityState.ATTACHED : EntityState.ATTACHED_NO_OID;
        }
        return EntityState.HOLLOW;
    }

    private static Method[] getMethodsProvidedByEnhancement() {
        return Persistable.class.getDeclaredMethods();
    }

    private static void ensureInit() {
        if (jdoMethodsProvidedByEnhancement.isEmpty()) {
            _NullSafe.stream((Object[])DnEntityStateProvider.getMethodsProvidedByEnhancement()).map(Method::toString).forEach(jdoMethodsProvidedByEnhancement::add);
        }
    }

    public EntityFacet createEntityFacet(FacetHolder facetHolder, Class<?> entityClass) {
        return new JdoEntityFacet(facetHolder, entityClass);
    }
}

