/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.progmodel.ProgrammingModel;
import org.apache.causeway.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.JdoQueriesFacetAnnotation;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.JdoQueryFacetAnnotation;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.MetaModelValidatorForJdoqlFromClause;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.MetaModelValidatorForJdoqlVariablesClause;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoQueryAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    private final JdoFacetContext jdoFacetContext;
    private static final Pattern fromPattern = Pattern.compile("SELECT.*?FROM[\\s]+([^\\s]+).*", 2);
    private static final Pattern variablesPattern = Pattern.compile(".*?VARIABLES[\\s]+([^\\s]+).*", 2);

    @Inject
    public JdoQueryAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Queries namedQueriesAnnotation = processClassContext.synthesizeOnType(Queries.class).orElse(null);
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        if (namedQueriesAnnotation != null) {
            this.addFacet((Facet)new JdoQueriesFacetAnnotation(namedQueriesAnnotation.value(), facetHolder));
            return;
        }
        Query namedQueryAnnotation = processClassContext.synthesizeOnType(Query.class).orElse(null);
        if (namedQueryAnnotation != null) {
            this.addFacet((Facet)new JdoQueryFacetAnnotation(namedQueryAnnotation, facetHolder));
        }
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        boolean isValidateVariablesClause;
        boolean isValidateFromClause = this.getConfiguration().getCore().getMetaModel().getValidator().getJdoql().isFromClause();
        if (isValidateFromClause) {
            programmingModel.addValidator((MetaModelValidator)new MetaModelValidatorForJdoqlFromClause(this.getMetaModelContext()), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        }
        if (isValidateVariablesClause = this.getConfiguration().getCore().getMetaModel().getValidator().getJdoql().isVariablesClause()) {
            programmingModel.addValidator((MetaModelValidator)new MetaModelValidatorForJdoqlVariablesClause(this.getMetaModelContext()), new ProgrammingModel.Marker[]{ProgrammingModel.Marker.JDO});
        }
    }

    static String from(String query) {
        Matcher matcher = fromPattern.matcher(query);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static String variables(String query) {
        Matcher matcher = variablesPattern.matcher(query);
        return matcher.matches() ? matcher.group(1) : null;
    }
}

