/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.query;

import java.util.Optional;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.MetaModelValidatorForJdoqlAbstract;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

class MetaModelValidatorForJdoqlVariablesClause
extends MetaModelValidatorForJdoqlAbstract {
    MetaModelValidatorForJdoqlVariablesClause(MetaModelContext mmc) {
        super(mmc, "VARIABLES");
    }

    @Override
    String deriveClause(String query) {
        return JdoQueryAnnotationFacetFactory.variables(query);
    }

    @Override
    void postInterpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query) {
        Optional persistenceCapableFacetIfAny = Try.call(() -> this.getSpecificationLoader().specForType(_Context.loadClass((String)classNameFromClause)).map(spec -> (JdoPersistenceCapableFacet)spec.getFacet(JdoPersistenceCapableFacet.class)).orElse(null)).getValue();
        if (persistenceCapableFacetIfAny.isEmpty()) {
            Class cls = objectSpec.getCorrespondingClass();
            ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)LogicalType.fqcn((Class)cls)), (String)String.format("%s: error in JDOQL query, class name for '%s' clause is not annotated as @PersistenceCapable (JDOQL : %s)", cls.getName(), this.clause, query));
        }
    }
}

