/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.version;

import jakarta.inject.Inject;
import java.lang.reflect.AnnotatedElement;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.jdo.annotations.Version;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.commons.internal.reflection._Reflect;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.version.JdoVersionFacetFromAnnotation;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoVersionAnnotationFacetFactory
extends FacetFactoryAbstract {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoVersionAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Optional versionIfAny = processClassContext.synthesizeOnType(Version.class);
        FacetUtil.addFacetIfPresent(JdoVersionFacetFromAnnotation.create(versionIfAny, processClassContext.getFacetHolder()));
        if (versionIfAny.isPresent()) {
            this.guardAgainstAmbiguousVersion(processClassContext);
        }
    }

    private void guardAgainstAmbiguousVersion(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        LinkedHashMap versionsFoundDirectly = _Maps.newLinkedHashMap();
        _Reflect.streamTypeHierarchy((Class)cls, (_Reflect.InterfacePolicy)_Reflect.InterfacePolicy.EXCLUDE).forEach(type -> _Annotations.synthesizeDirect((AnnotatedElement)type, Version.class).ifPresent(versionDirect -> versionsFoundDirectly.put(type, versionDirect)));
        if (versionsFoundDirectly.size() > 1) {
            ValidationFailure.raiseFormatted((FacetHolder)processClassContext.getFacetHolder(), (String)"@Version annotation is ambiguous within a class hierarchy, there can be only one. Conflicting types are: %s", (Object[])new Object[]{versionsFoundDirectly.keySet()});
        }
    }
}

