/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.beans;

import java.util.Locale;
import java.util.Optional;
import javax.jdo.annotations.EmbeddedOnly;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.core.config.beans.CausewayBeanMetaData;
import org.apache.causeway.core.config.beans.CausewayBeanTypeClassifier;
import org.apache.causeway.core.config.beans.PersistenceStack;

public class JdoBeanTypeClassifier
implements CausewayBeanTypeClassifier {
    public CausewayBeanMetaData classify(Class<?> type) {
        Optional persistenceCapableAnnot = _Annotations.synthesize(type, PersistenceCapable.class);
        if (persistenceCapableAnnot.isPresent()) {
            String schema;
            boolean embeddedOnly;
            String embeddedOnlyAttribute = ((PersistenceCapable)persistenceCapableAnnot.get()).embeddedOnly();
            boolean bl = embeddedOnly = Boolean.valueOf(embeddedOnlyAttribute) != false || _Annotations.synthesize(type, EmbeddedOnly.class).isPresent();
            if (embeddedOnly) {
                return null;
            }
            LogicalType logicalType = LogicalType.infer(type);
            if (logicalType.getLogicalTypeName().equals(type.getName()) && _Strings.isNotEmpty((CharSequence)(schema = ((PersistenceCapable)persistenceCapableAnnot.get()).schema()))) {
                String table = ((PersistenceCapable)persistenceCapableAnnot.get()).table();
                String logicalTypeName = String.format("%s.%s", schema.toLowerCase(Locale.ROOT), _Strings.isNotEmpty((CharSequence)table) ? table : type.getSimpleName());
                logicalType = LogicalType.eager(type, (String)logicalTypeName);
            }
            return CausewayBeanMetaData.entity((PersistenceStack)PersistenceStack.JDO, (LogicalType)logicalType);
        }
        return null;
    }
}

