/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.fixtures.applib.fixturescripts;

import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecification;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecificationProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureOrder(value=0x5FFFFFFF)
@Configuration
public class FixtureScriptsSpecificationProviderAutoConfiguration {
    @Bean(value={"causeway.testing.fixtures.FixtureScriptsSpecificationProviderDefault"})
    @ConditionalOnMissingBean(value={FixtureScriptsSpecificationProvider.class})
    @Qualifier(value="Default")
    FixtureScriptsSpecificationProvider fixtureScriptsSpecificationProvider(CausewayConfiguration causewayConfiguration) {
        CausewayConfiguration.Testing.Fixtures.FixtureScriptsSpecification fixturesConfig = causewayConfiguration.getTesting().getFixtures().getFixtureScriptsSpecification();
        FixtureScriptsSpecification.Builder builder = FixtureScriptsSpecificationProviderAutoConfiguration.builderFrom(fixturesConfig);
        builder.with(FixtureScripts.NonPersistedObjectsStrategy.valueOf(fixturesConfig.getNonPersistedObjectsStrategy().name()));
        builder.with(FixtureScripts.MultipleExecutionStrategy.valueOf(fixturesConfig.getMultipleExecutionStrategy().name()));
        builder.withRecreate(fixturesConfig.getRecreate());
        builder.withRunScriptDefault(fixturesConfig.getRunScriptDefault());
        return builder::build;
    }

    private static FixtureScriptsSpecification.Builder builderFrom(CausewayConfiguration.Testing.Fixtures.FixtureScriptsSpecification fixturesConfig) {
        Class contextClass = fixturesConfig.getContextClass();
        if (contextClass != null) {
            return FixtureScriptsSpecification.builder(contextClass);
        }
        String packagePrefix = fixturesConfig.getPackagePrefix();
        return FixtureScriptsSpecification.builder(packagePrefix);
    }
}

