/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.applib.services.menu;

import lombok.NonNull;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.springframework.lang.Nullable;

public final class MenuItemDto {
    @NonNull
    private final String name;
    @Nullable
    private final String cssClassFa;
    @Nullable
    private final ManagedAction managedAction;
    private final boolean isTertiaryRoot;

    public static MenuItemDto topLevel(String name, String cssClassFa) {
        return MenuItemDto.of(name, cssClassFa, null, false);
    }

    public static MenuItemDto tertiaryRoot(String name, String cssClassFa) {
        return MenuItemDto.of(name, cssClassFa, null, true);
    }

    public static MenuItemDto subMenu(@NonNull ManagedAction managedAction, String named, String cssClassFa) {
        if (managedAction == null) {
            throw new NullPointerException("managedAction is marked non-null but is null");
        }
        String name = _Strings.isNotEmpty((CharSequence)named) ? named : managedAction.getFriendlyName();
        return MenuItemDto.of(name, cssClassFa, managedAction, false);
    }

    private MenuItemDto(@NonNull String name, @Nullable String cssClassFa, @Nullable ManagedAction managedAction, boolean isTertiaryRoot) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.cssClassFa = cssClassFa;
        this.managedAction = managedAction;
        this.isTertiaryRoot = isTertiaryRoot;
    }

    public static MenuItemDto of(@NonNull String name, @Nullable String cssClassFa, @Nullable ManagedAction managedAction, boolean isTertiaryRoot) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new MenuItemDto(name, cssClassFa, managedAction, isTertiaryRoot);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getCssClassFa() {
        return this.cssClassFa;
    }

    @Nullable
    public ManagedAction getManagedAction() {
        return this.managedAction;
    }

    public boolean isTertiaryRoot() {
        return this.isTertiaryRoot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuItemDto)) {
            return false;
        }
        MenuItemDto other = (MenuItemDto)o;
        if (this.isTertiaryRoot() != other.isTertiaryRoot()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$cssClassFa = this.getCssClassFa();
        String other$cssClassFa = other.getCssClassFa();
        if (this$cssClassFa == null ? other$cssClassFa != null : !this$cssClassFa.equals(other$cssClassFa)) {
            return false;
        }
        ManagedAction this$managedAction = this.getManagedAction();
        ManagedAction other$managedAction = other.getManagedAction();
        return !(this$managedAction == null ? other$managedAction != null : !this$managedAction.equals(other$managedAction));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTertiaryRoot() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $cssClassFa = this.getCssClassFa();
        result = result * 59 + ($cssClassFa == null ? 43 : $cssClassFa.hashCode());
        ManagedAction $managedAction = this.getManagedAction();
        result = result * 59 + ($managedAction == null ? 43 : $managedAction.hashCode());
        return result;
    }

    public String toString() {
        return "MenuItemDto(name=" + this.getName() + ", cssClassFa=" + this.getCssClassFa() + ", managedAction=" + this.getManagedAction() + ", isTertiaryRoot=" + this.isTertiaryRoot() + ")";
    }
}

