/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.model.components;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.causeway.applib.annotation.LabelPosition;
import org.apache.causeway.commons.handler.ChainOfResponsibility;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedFeature;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedParameter;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedProperty;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedValue;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.util.Facets;
import org.apache.causeway.viewer.commons.model.decorators.DisablingDecorator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface UiComponentFactory<B, C> {
    public B buttonFor(ButtonRequest var1);

    public C componentFor(ComponentRequest var1);

    public C parameterFor(ComponentRequest var1);

    public LabelAndPosition<C> labelFor(ComponentRequest var1);

    public static interface Handler<T>
    extends ChainOfResponsibility.Handler<ComponentRequest, T> {
    }

    public record ComponentRequest(@NonNull ManagedValue managedValue, @NonNull ManagedFeature managedFeature, @NonNull Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny) {
        public static ComponentRequest of(ManagedParameter managedParameter) {
            return new ComponentRequest((ManagedValue)managedParameter, (ManagedFeature)managedParameter, Optional.empty());
        }

        public String getFriendlyName() {
            return this.managedFeature.getFriendlyName();
        }

        public ObjectSpecification getFeatureTypeSpec() {
            return this.managedFeature.getElementType();
        }

        public Class<?> getFeatureType() {
            return this.managedFeature.getElementClass();
        }

        public boolean isFeatureTypeEqualTo(@Nullable Class<?> type) {
            return this.getFeatureType() == type;
        }

        public boolean isFeatureTypeAssignableFrom(@Nullable Class<?> type) {
            return type != null ? this.getFeatureType().isAssignableFrom(type) : false;
        }

        public boolean isFeatureTypeInstanceOf(@Nullable Class<?> type) {
            return type != null ? type.isAssignableFrom(this.getFeatureType()) : false;
        }

        public <T extends Facet> boolean hasFeatureTypeFacet(@Nullable Class<T> facetType) {
            return facetType != null ? this.getFeatureTypeSpec().containsFacet(facetType) : false;
        }

        public boolean hasFacetForValueType(@Nullable Class<?> valueType) {
            return valueType != null ? Facets.valueTypeMatches(valueType::equals).test(this.getFeatureTypeSpec()) : false;
        }

        public boolean isReadOnly() {
            return ((ManagedProperty)this.managedFeature).checkUsability().isPresent();
        }
    }

    public record ButtonRequest(@NonNull ManagedAction managedAction, @NonNull Optional<DisablingDecorator.DisablingDecorationModel> disablingUiModelIfAny, @NonNull Consumer<ManagedAction> actionEventHandler) {
    }

    public record LabelAndPosition<T>(@NonNull LabelPosition labelPosition, @NonNull T uiLabel) {
    }
}

