/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.services.menu;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.layout.menubars.bootstrap.BSMenuBar;
import org.apache.causeway.applib.services.menu.MenuBarsService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuItemDto;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuUiService;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuDropdownBuilder;
import org.apache.causeway.viewer.commons.applib.services.menu.model.NavbarSection;
import org.apache.causeway.viewer.commons.applib.services.menu.model.NavbarUiModel;
import org.apache.causeway.viewer.commons.services.menu._MenuItemBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.commons.MenuUiServiceDefault")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Default")
public class MenuUiServiceDefault
implements MenuUiService {
    private final MetaModelContext metaModelContext;
    private final MenuBarsService menuBarsService;

    public NavbarUiModel getMenu() {
        return new NavbarUiModel(this.buildNavBarSection(DomainServiceLayout.MenuBar.PRIMARY), this.buildNavBarSection(DomainServiceLayout.MenuBar.SECONDARY), this.buildNavBarSection(DomainServiceLayout.MenuBar.TERTIARY));
    }

    private NavbarSection buildNavBarSection(DomainServiceLayout.MenuBar menuBarSelect) {
        BSMenuBar menuBar = (BSMenuBar)this.menuBarsService.menuBars().menuBarFor(menuBarSelect);
        final ArrayList topLevelEntries = new ArrayList();
        _MenuItemBuilder.buildMenuItems(this.metaModelContext, menuBar, new _MenuItemBuilder.Visitor(){
            private MenuDropdownBuilder currentMenu;

            @Override
            public void addTopLevel(MenuItemDto menuDto) {
                this.currentMenu = new MenuDropdownBuilder(menuDto.getName(), new ArrayList());
                topLevelEntries.add(this.currentMenu);
            }

            @Override
            public void addSectionSpacer() {
                this.currentMenu.addSectionSpacer();
            }

            @Override
            public void addSectionLabel(String named) {
                this.currentMenu.addSectionSpacer(named);
            }

            @Override
            public void addMenuAction(MenuItemDto menuDto) {
                ManagedAction action = menuDto.getManagedAction();
                this.currentMenu.addAction(action);
            }
        });
        return new NavbarSection(menuBarSelect, Can.ofCollection(topLevelEntries).map(MenuDropdownBuilder::build));
    }

    @Inject
    public MenuUiServiceDefault(MetaModelContext metaModelContext, MenuBarsService menuBarsService) {
        this.metaModelContext = metaModelContext;
        this.menuBarsService = menuBarsService;
    }
}

