/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import java.util.Optional;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.domain.rich.query.RichPropertyGetClobAbstract;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public class RichPropertyGetClobChars
extends RichPropertyGetClobAbstract {
    private final String graphqlPath;

    public RichPropertyGetClobChars(MemberInteractor<OneToOneAssociation> memberInteractor, Context context) {
        super(memberInteractor, context, "chars");
        this.graphqlPath = context.causewayConfiguration.valueOf("spring.graphql.path").orElse("/graphql");
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment environment) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(environment);
        Optional bookmarkIfAny = this.context.bookmarkService.bookmarkFor(sourcePojo);
        return bookmarkIfAny.map(x -> {
            Object objectFeature = this.holder.getObjectMember();
            return String.format("//%s/object/%s:%s/%s/clobChars", this.graphqlPath, x.getLogicalTypeName(), x.getIdentifier(), objectFeature.asciiId());
        }).orElse(null);
    }
}

