/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.simple.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.Clob;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneFeature;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.Parent;
import org.apache.causeway.viewer.graphql.model.domain.SchemaType;
import org.apache.causeway.viewer.graphql.model.domain.TypeNames;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.ObjectInteractor;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimplePropertyLobBytes;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimplePropertyLobChars;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimplePropertyLobMimeType;
import org.apache.causeway.viewer.graphql.model.domain.simple.query.SimplePropertyLobName;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;

public class SimpleProperty
extends Element
implements MemberInteractor<OneToOneAssociation>,
Parent {
    final ObjectInteractor objectInteractor;
    private final OneToOneAssociation objectMember;
    final GraphQLObjectType gqlObjectType;
    final SimplePropertyLobName lobName;
    final SimplePropertyLobMimeType lobMimeType;
    final SimplePropertyLobBytes lobBytes;
    final SimplePropertyLobChars lobChars;

    String getTypeName() {
        return this.gqlObjectType != null ? this.gqlObjectType.getName() : null;
    }

    public SimpleProperty(ObjectInteractor objectInteractor, OneToOneAssociation otoa, Context context) {
        super(context);
        GraphQLOutputType gqlOutputType;
        this.objectInteractor = objectInteractor;
        this.objectMember = otoa;
        if (SimpleProperty.isBlobOrClob(otoa)) {
            GraphQLObjectType.Builder glqObjectTypeBuilder = GraphQLObjectType.newObject().name(TypeNames.memberTypeNameFor(objectInteractor.getObjectSpecification(), (ObjectMember)otoa, objectInteractor.getSchemaType())).description(otoa.getCanonicalDescription().orElse(otoa.getCanonicalFriendlyName()));
            this.lobName = new SimplePropertyLobName(this, context);
            SimpleProperty.addChildFieldFor(glqObjectTypeBuilder, this.lobName);
            this.lobMimeType = new SimplePropertyLobMimeType(this, context);
            SimpleProperty.addChildFieldFor(glqObjectTypeBuilder, this.lobMimeType);
            if (SimpleProperty.isBlob(this.getObjectMember())) {
                this.lobBytes = new SimplePropertyLobBytes(this, context);
                SimpleProperty.addChildFieldFor(glqObjectTypeBuilder, this.lobBytes);
                this.lobChars = null;
            } else {
                this.lobChars = new SimplePropertyLobChars(this, context);
                SimpleProperty.addChildFieldFor(glqObjectTypeBuilder, this.lobChars);
                this.lobBytes = null;
            }
            this.gqlObjectType = glqObjectTypeBuilder.build();
            gqlOutputType = this.gqlObjectType;
        } else {
            this.gqlObjectType = null;
            gqlOutputType = SimpleProperty.outputType(objectInteractor, otoa, context);
            this.lobName = null;
            this.lobMimeType = null;
            this.lobBytes = null;
            this.lobChars = null;
        }
        if (gqlOutputType != null) {
            GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(otoa.asciiId()).type(gqlOutputType);
            this.setField(fieldBuilder.build());
        } else {
            this.setField(null);
        }
    }

    private static GraphQLOutputType outputType(ObjectInteractor objectInteractor, OneToOneAssociation otoa, Context context) {
        if (SimpleProperty.isBlobOrClob(otoa)) {
            String typeName = TypeNames.propertyLobTypeNameFor(objectInteractor.getObjectSpecification(), otoa, objectInteractor.getSchemaType());
            return GraphQLObjectType.newObject().name(typeName).build();
        }
        return context.typeMapper.outputTypeFor((OneToOneFeature)otoa, objectInteractor.getSchemaType());
    }

    static <T extends Element> void addChildFieldFor(GraphQLObjectType.Builder glqObjectTypeBuilder, T hasField) {
        GraphQLFieldDefinition childField = hasField.getField();
        if (childField != null) {
            glqObjectTypeBuilder.field(childField);
        }
    }

    @Override
    protected void addDataFetchersForChildren() {
        if (this.lobName != null) {
            this.lobName.addDataFetcher(this);
        }
        if (this.lobMimeType != null) {
            this.lobMimeType.addDataFetcher(this);
        }
        if (this.lobBytes != null) {
            this.lobBytes.addDataFetcher(this);
        }
        if (this.lobChars != null) {
            this.lobChars.addDataFetcher(this);
        }
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        ManagedObject managedObject;
        if (SimpleProperty.isBlobOrClob(this.getObjectMember())) {
            return BookmarkedPojo.sourceFrom(dataFetchingEnvironment, this.context);
        }
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        Class<?> sourcePojoClass = sourcePojo.getClass();
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojoClass);
        if (objectSpecification == null) {
            return null;
        }
        OneToOneAssociation association = this.getObjectMember();
        ManagedObject resultManagedObject = association.get(managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo));
        return resultManagedObject != null ? resultManagedObject.getPojo() : null;
    }

    private static boolean isBlobOrClob(OneToOneAssociation otota) {
        return SimpleProperty.isBlob(otota) || SimpleProperty.isClob(otota);
    }

    private static boolean isBlob(OneToOneAssociation otoa) {
        return otoa.getElementType().getCorrespondingClass() == Blob.class;
    }

    private static boolean isClob(OneToOneAssociation otoa) {
        return otoa.getElementType().getCorrespondingClass() == Clob.class;
    }

    @Override
    public ObjectSpecification getObjectSpecification() {
        return this.objectInteractor.getObjectSpecification();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.objectInteractor.getSchemaType();
    }

    @Override
    public final FieldCoordinates coordinatesFor(GraphQLFieldDefinition field) {
        if (this.gqlObjectType == null) {
            throw new IllegalStateException(String.format("GQL Object Type for '%s' not yet built", this.getTypeName()));
        }
        return FieldCoordinates.coordinates((GraphQLFieldsContainer)this.gqlObjectType, (GraphQLFieldDefinition)field);
    }

    @Override
    public final FieldCoordinates coordinatesFor(String fieldName) {
        if (this.gqlObjectType == null) {
            throw new IllegalStateException(String.format("GQL Object Type for '%s' not yet built", this.getTypeName()));
        }
        return FieldCoordinates.coordinates((GraphQLFieldsContainer)this.gqlObjectType, (String)fieldName);
    }

    public ObjectInteractor getObjectInteractor() {
        return this.objectInteractor;
    }

    @Override
    public OneToOneAssociation getObjectMember() {
        return this.objectMember;
    }
}

