/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.graphql.model.domain.rich.query;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.viewer.graphql.model.context.Context;
import org.apache.causeway.viewer.graphql.model.domain.Element;
import org.apache.causeway.viewer.graphql.model.domain.common.interactors.MemberInteractor;
import org.apache.causeway.viewer.graphql.model.fetcher.BookmarkedPojo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RichMemberHidden<T extends ObjectMember>
extends Element {
    private static final Logger log = LogManager.getLogger(RichMemberHidden.class);
    private final MemberInteractor<T> memberInteractor;

    public RichMemberHidden(MemberInteractor<T> memberInteractor, Context context) {
        super(context);
        this.memberInteractor = memberInteractor;
        this.setField(GraphQLFieldDefinition.newFieldDefinition().name("hidden").type(this.context.typeMapper.outputTypeFor(Boolean.TYPE)).build());
    }

    @Override
    protected Object fetchData(DataFetchingEnvironment dataFetchingEnvironment) {
        Object sourcePojo = BookmarkedPojo.sourceFrom(dataFetchingEnvironment);
        Class<?> sourcePojoClass = sourcePojo.getClass();
        ObjectSpecification objectSpecification = this.context.specificationLoader.loadSpecification(sourcePojoClass);
        if (objectSpecification == null) {
            return true;
        }
        Object objectMember = this.memberInteractor.getObjectMember();
        ManagedObject managedObject = ManagedObject.adaptSingular((ObjectSpecification)objectSpecification, (Object)sourcePojo);
        Consent visibleConsent = objectMember.isVisible(managedObject, InteractionInitiatedBy.USER, Where.ANYWHERE);
        return visibleConsent.isVetoed();
    }
}

